<?php

namespace EnumType;

/**
 * This class stands for PiecesEnabled EnumType
 * @subpackage Enumerations
 */
class PiecesEnabled
{
    /**
     * Constant for value 'S'
     * Meta informations extracted from the WSDL
     * - documentation: S for Only Shipment Details
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'P'
     * Meta informations extracted from the WSDL
     * - documentation: P for Only Piece Details
     * @return string 'P'
     */
    const VALUE_P = 'P';
    /**
     * Constant for value 'B'
     * Meta informations extracted from the WSDL
     * - documentation: B for both Piece and Shipment Details
     * @return string 'B'
     */
    const VALUE_B = 'B';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_S
     * @uses self::VALUE_P
     * @uses self::VALUE_B
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_S,
            self::VALUE_P,
            self::VALUE_B,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
