<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAWBInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfAWBInfo extends AbstractStructArrayBase
{
    /**
     * The ArrayOfAWBInfoItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * @var \StructType\AWBInfo[]
     */
    public $ArrayOfAWBInfoItem;
    /**
     * Constructor method for ArrayOfAWBInfo
     * @uses ArrayOfAWBInfo::setArrayOfAWBInfoItem()
     * @param \StructType\AWBInfo[] $arrayOfAWBInfoItem
     */
    public function __construct(array $arrayOfAWBInfoItem = array())
    {
        $this
            ->setArrayOfAWBInfoItem($arrayOfAWBInfoItem);
    }
    /**
     * Get ArrayOfAWBInfoItem value
     * @return \StructType\AWBInfo[]|null
     */
    public function getArrayOfAWBInfoItem()
    {
        return $this->ArrayOfAWBInfoItem;
    }
    /**
     * This method is responsible for validating the values passed to the setArrayOfAWBInfoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrayOfAWBInfoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayOfAWBInfoItemForArrayConstraintsFromSetArrayOfAWBInfoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAWBInfoArrayOfAWBInfoItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAWBInfoArrayOfAWBInfoItemItem instanceof \StructType\AWBInfo) {
                $invalidValues[] = is_object($arrayOfAWBInfoArrayOfAWBInfoItemItem) ? get_class($arrayOfAWBInfoArrayOfAWBInfoItemItem) : sprintf('%s(%s)', gettype($arrayOfAWBInfoArrayOfAWBInfoItemItem), var_export($arrayOfAWBInfoArrayOfAWBInfoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArrayOfAWBInfoItem property can only contain items of type \StructType\AWBInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArrayOfAWBInfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AWBInfo[] $arrayOfAWBInfoItem
     * @return \ArrayType\ArrayOfAWBInfo
     */
    public function setArrayOfAWBInfoItem(array $arrayOfAWBInfoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayOfAWBInfoItemArrayErrorMessage = self::validateArrayOfAWBInfoItemForArrayConstraintsFromSetArrayOfAWBInfoItem($arrayOfAWBInfoItem))) {
            throw new \InvalidArgumentException($arrayOfAWBInfoItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($arrayOfAWBInfoItem) && count($arrayOfAWBInfoItem) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($arrayOfAWBInfoItem)), __LINE__);
        }
        $this->ArrayOfAWBInfoItem = $arrayOfAWBInfoItem;
        return $this;
    }
    /**
     * Add item to ArrayOfAWBInfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AWBInfo $item
     * @return \ArrayType\ArrayOfAWBInfo
     */
    public function addToArrayOfAWBInfoItem(\StructType\AWBInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AWBInfo) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfAWBInfoItem property can only contain items of type \StructType\AWBInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->ArrayOfAWBInfoItem) && count($this->ArrayOfAWBInfoItem) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->ArrayOfAWBInfoItem)), __LINE__);
        }
        $this->ArrayOfAWBInfoItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AWBInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AWBInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AWBInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AWBInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AWBInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfAWBInfoItem
     */
    public function getAttributeName()
    {
        return 'ArrayOfAWBInfoItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAWBInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
