<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipper StructType
 * @subpackage Structs
 */
class Shipper extends AbstractStructBase
{
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: City name
     * - base: xsd:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Suburb
     * Meta informations extracted from the WSDL
     * - documentation: Suburb
     * - base: xsd:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $Suburb;
    /**
     * The StateOrProvinceCode
     * Meta informations extracted from the WSDL
     * - documentation: State or province code
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $StateOrProvinceCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - documentation: Full postal/zip code for address
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: ISO 2 character code of country
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for Shipper
     * @uses Shipper::setCity()
     * @uses Shipper::setSuburb()
     * @uses Shipper::setStateOrProvinceCode()
     * @uses Shipper::setPostalCode()
     * @uses Shipper::setCountryCode()
     * @param string $city
     * @param string $suburb
     * @param string $stateOrProvinceCode
     * @param string $postalCode
     * @param string $countryCode
     */
    public function __construct($city = null, $suburb = null, $stateOrProvinceCode = null, $postalCode = null, $countryCode = null)
    {
        $this
            ->setCity($city)
            ->setSuburb($suburb)
            ->setStateOrProvinceCode($stateOrProvinceCode)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Shipper
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Suburb value
     * @return string|null
     */
    public function getSuburb()
    {
        return $this->Suburb;
    }
    /**
     * Set Suburb value
     * @param string $suburb
     * @return \StructType\Shipper
     */
    public function setSuburb($suburb = null)
    {
        // validation for constraint: string
        if (!is_null($suburb) && !is_string($suburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suburb, true), gettype($suburb)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($suburb) && mb_strlen($suburb) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($suburb)), __LINE__);
        }
        $this->Suburb = $suburb;
        return $this;
    }
    /**
     * Get StateOrProvinceCode value
     * @return string|null
     */
    public function getStateOrProvinceCode()
    {
        return $this->StateOrProvinceCode;
    }
    /**
     * Set StateOrProvinceCode value
     * @param string $stateOrProvinceCode
     * @return \StructType\Shipper
     */
    public function setStateOrProvinceCode($stateOrProvinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvinceCode) && !is_string($stateOrProvinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvinceCode, true), gettype($stateOrProvinceCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($stateOrProvinceCode) && mb_strlen($stateOrProvinceCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($stateOrProvinceCode)), __LINE__);
        }
        $this->StateOrProvinceCode = $stateOrProvinceCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Shipper
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Shipper
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
