<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceEvent StructType
 * @subpackage Structs
 */
class ServiceEvent extends AbstractStructBase
{
    /**
     * The EventCode
     * Meta informations extracted from the WSDL
     * - documentation: The event code for this specific event.
     * - base: xsd:string
     * - length: 2
     * - whiteSpace: preserve
     * @var string
     */
    public $EventCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the event
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ServiceEvent
     * @uses ServiceEvent::setEventCode()
     * @uses ServiceEvent::setDescription()
     * @param string $eventCode
     * @param string $description
     */
    public function __construct($eventCode = null, $description = null)
    {
        $this
            ->setEventCode($eventCode)
            ->setDescription($description);
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\ServiceEvent
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($eventCode) && mb_strlen($eventCode) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ServiceEvent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
