<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginServiceArea StructType
 * @subpackage Structs
 */
class OriginServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - documentation: The DHL Service Area Code for the origin/destination of the Shipment
     * - base: xsd:string
     * - length: 3
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the Service Area Code
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The OutboundSortCode
     * Meta informations extracted from the WSDL
     * - documentation: Outbound Sort Code of Origin (currently not available)
     * - base: xsd:string
     * - length: 4
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $OutboundSortCode;
    /**
     * Constructor method for OriginServiceArea
     * @uses OriginServiceArea::setServiceAreaCode()
     * @uses OriginServiceArea::setDescription()
     * @uses OriginServiceArea::setOutboundSortCode()
     * @param string $serviceAreaCode
     * @param string $description
     * @param string $outboundSortCode
     */
    public function __construct($serviceAreaCode = null, $description = null, $outboundSortCode = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description)
            ->setOutboundSortCode($outboundSortCode);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\OriginServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($serviceAreaCode) && mb_strlen($serviceAreaCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OriginServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get OutboundSortCode value
     * @return string|null
     */
    public function getOutboundSortCode()
    {
        return $this->OutboundSortCode;
    }
    /**
     * Set OutboundSortCode value
     * @param string $outboundSortCode
     * @return \StructType\OriginServiceArea
     */
    public function setOutboundSortCode($outboundSortCode = null)
    {
        // validation for constraint: string
        if (!is_null($outboundSortCode) && !is_string($outboundSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outboundSortCode, true), gettype($outboundSortCode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($outboundSortCode) && mb_strlen($outboundSortCode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($outboundSortCode)), __LINE__);
        }
        $this->OutboundSortCode = $outboundSortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
