<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShipmentEvent ArrayType
 * @subpackage Arrays
 */
class ArrayOfShipmentEvent extends AbstractStructArrayBase
{
    /**
     * The ArrayOfShipmentEventItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * @var \StructType\ShipmentEvent[]
     */
    public $ArrayOfShipmentEventItem;
    /**
     * Constructor method for ArrayOfShipmentEvent
     * @uses ArrayOfShipmentEvent::setArrayOfShipmentEventItem()
     * @param \StructType\ShipmentEvent[] $arrayOfShipmentEventItem
     */
    public function __construct(array $arrayOfShipmentEventItem = array())
    {
        $this
            ->setArrayOfShipmentEventItem($arrayOfShipmentEventItem);
    }
    /**
     * Get ArrayOfShipmentEventItem value
     * @return \StructType\ShipmentEvent[]|null
     */
    public function getArrayOfShipmentEventItem()
    {
        return $this->ArrayOfShipmentEventItem;
    }
    /**
     * This method is responsible for validating the values passed to the setArrayOfShipmentEventItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrayOfShipmentEventItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayOfShipmentEventItemForArrayConstraintsFromSetArrayOfShipmentEventItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShipmentEventArrayOfShipmentEventItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipmentEventArrayOfShipmentEventItemItem instanceof \StructType\ShipmentEvent) {
                $invalidValues[] = is_object($arrayOfShipmentEventArrayOfShipmentEventItemItem) ? get_class($arrayOfShipmentEventArrayOfShipmentEventItemItem) : sprintf('%s(%s)', gettype($arrayOfShipmentEventArrayOfShipmentEventItemItem), var_export($arrayOfShipmentEventArrayOfShipmentEventItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArrayOfShipmentEventItem property can only contain items of type \StructType\ShipmentEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArrayOfShipmentEventItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentEvent[] $arrayOfShipmentEventItem
     * @return \ArrayType\ArrayOfShipmentEvent
     */
    public function setArrayOfShipmentEventItem(array $arrayOfShipmentEventItem = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayOfShipmentEventItemArrayErrorMessage = self::validateArrayOfShipmentEventItemForArrayConstraintsFromSetArrayOfShipmentEventItem($arrayOfShipmentEventItem))) {
            throw new \InvalidArgumentException($arrayOfShipmentEventItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($arrayOfShipmentEventItem) && count($arrayOfShipmentEventItem) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($arrayOfShipmentEventItem)), __LINE__);
        }
        $this->ArrayOfShipmentEventItem = $arrayOfShipmentEventItem;
        return $this;
    }
    /**
     * Add item to ArrayOfShipmentEventItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentEvent $item
     * @return \ArrayType\ArrayOfShipmentEvent
     */
    public function addToArrayOfShipmentEventItem(\StructType\ShipmentEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentEvent) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfShipmentEventItem property can only contain items of type \StructType\ShipmentEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->ArrayOfShipmentEventItem) && count($this->ArrayOfShipmentEventItem) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->ArrayOfShipmentEventItem)), __LINE__);
        }
        $this->ArrayOfShipmentEventItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShipmentEvent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShipmentEvent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShipmentEvent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShipmentEvent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShipmentEvent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfShipmentEventItem
     */
    public function getAttributeName()
    {
        return 'ArrayOfShipmentEventItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShipmentEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
