<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationServiceArea StructType
 * @subpackage Structs
 */
class DestinationServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - documentation: The DHL Service Area Code for the origin/destination of the Shipment
     * - base: xsd:string
     * - length: 3
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the Service Area Code
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FacilityCode
     * Meta informations extracted from the WSDL
     * - documentation: The DHL Facility Code for the Destination
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $FacilityCode;
    /**
     * The InboundSortCode
     * Meta informations extracted from the WSDL
     * - documentation: Inbound Sort Code of Destination (currently not available)
     * - base: xsd:string
     * - length: 4
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $InboundSortCode;
    /**
     * Constructor method for DestinationServiceArea
     * @uses DestinationServiceArea::setServiceAreaCode()
     * @uses DestinationServiceArea::setDescription()
     * @uses DestinationServiceArea::setFacilityCode()
     * @uses DestinationServiceArea::setInboundSortCode()
     * @param string $serviceAreaCode
     * @param string $description
     * @param string $facilityCode
     * @param string $inboundSortCode
     */
    public function __construct($serviceAreaCode = null, $description = null, $facilityCode = null, $inboundSortCode = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description)
            ->setFacilityCode($facilityCode)
            ->setInboundSortCode($inboundSortCode);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\DestinationServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($serviceAreaCode) && mb_strlen($serviceAreaCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DestinationServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\DestinationServiceArea
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($facilityCode) && mb_strlen($facilityCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get InboundSortCode value
     * @return string|null
     */
    public function getInboundSortCode()
    {
        return $this->InboundSortCode;
    }
    /**
     * Set InboundSortCode value
     * @param string $inboundSortCode
     * @return \StructType\DestinationServiceArea
     */
    public function setInboundSortCode($inboundSortCode = null)
    {
        // validation for constraint: string
        if (!is_null($inboundSortCode) && !is_string($inboundSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inboundSortCode, true), gettype($inboundSortCode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($inboundSortCode) && mb_strlen($inboundSortCode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($inboundSortCode)), __LINE__);
        }
        $this->InboundSortCode = $inboundSortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
