<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Condition StructType
 * @subpackage Structs
 */
class Condition extends AbstractStructBase
{
    /**
     * The ConditionCode
     * Meta informations extracted from the WSDL
     * - documentation: Error Code associated to the request
     * @var string
     */
    public $ConditionCode;
    /**
     * The ConditionData
     * Meta informations extracted from the WSDL
     * - documentation: Error Description
     * - minOccurs: 0
     * @var string
     */
    public $ConditionData;
    /**
     * Constructor method for Condition
     * @uses Condition::setConditionCode()
     * @uses Condition::setConditionData()
     * @param string $conditionCode
     * @param string $conditionData
     */
    public function __construct($conditionCode = null, $conditionData = null)
    {
        $this
            ->setConditionCode($conditionCode)
            ->setConditionData($conditionData);
    }
    /**
     * Get ConditionCode value
     * @return string|null
     */
    public function getConditionCode()
    {
        return $this->ConditionCode;
    }
    /**
     * Set ConditionCode value
     * @param string $conditionCode
     * @return \StructType\Condition
     */
    public function setConditionCode($conditionCode = null)
    {
        // validation for constraint: string
        if (!is_null($conditionCode) && !is_string($conditionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionCode, true), gettype($conditionCode)), __LINE__);
        }
        $this->ConditionCode = $conditionCode;
        return $this;
    }
    /**
     * Get ConditionData value
     * @return string|null
     */
    public function getConditionData()
    {
        return $this->ConditionData;
    }
    /**
     * Set ConditionData value
     * @param string $conditionData
     * @return \StructType\Condition
     */
    public function setConditionData($conditionData = null)
    {
        // validation for constraint: string
        if (!is_null($conditionData) && !is_string($conditionData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionData, true), gettype($conditionData)), __LINE__);
        }
        $this->ConditionData = $conditionData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Condition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
