<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AWBInfo StructType
 * @subpackage Structs
 */
class AWBInfo extends AbstractStructBase
{
    /**
     * The AWBNumber
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the piece number as a counter, same as input.
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 10
     * - whiteSpace: preserve
     * @var string
     */
    public $AWBNumber;
    /**
     * The TrackedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TrackedBy
     */
    public $TrackedBy;
    /**
     * The Status
     * @var \StructType\Status
     */
    public $Status;
    /**
     * The ShipmentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentInfo
     */
    public $ShipmentInfo;
    /**
     * The Pieces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TrackingPieces
     */
    public $Pieces;
    /**
     * Constructor method for AWBInfo
     * @uses AWBInfo::setAWBNumber()
     * @uses AWBInfo::setTrackedBy()
     * @uses AWBInfo::setStatus()
     * @uses AWBInfo::setShipmentInfo()
     * @uses AWBInfo::setPieces()
     * @param string $aWBNumber
     * @param \StructType\TrackedBy $trackedBy
     * @param \StructType\Status $status
     * @param \StructType\ShipmentInfo $shipmentInfo
     * @param \StructType\TrackingPieces $pieces
     */
    public function __construct($aWBNumber = null, \StructType\TrackedBy $trackedBy = null, \StructType\Status $status = null, \StructType\ShipmentInfo $shipmentInfo = null, \StructType\TrackingPieces $pieces = null)
    {
        $this
            ->setAWBNumber($aWBNumber)
            ->setTrackedBy($trackedBy)
            ->setStatus($status)
            ->setShipmentInfo($shipmentInfo)
            ->setPieces($pieces);
    }
    /**
     * Get AWBNumber value
     * @return string|null
     */
    public function getAWBNumber()
    {
        return $this->AWBNumber;
    }
    /**
     * Set AWBNumber value
     * @param string $aWBNumber
     * @return \StructType\AWBInfo
     */
    public function setAWBNumber($aWBNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aWBNumber) && !is_string($aWBNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aWBNumber, true), gettype($aWBNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($aWBNumber) && mb_strlen($aWBNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($aWBNumber)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($aWBNumber) && mb_strlen($aWBNumber) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($aWBNumber)), __LINE__);
        }
        $this->AWBNumber = $aWBNumber;
        return $this;
    }
    /**
     * Get TrackedBy value
     * @return \StructType\TrackedBy|null
     */
    public function getTrackedBy()
    {
        return $this->TrackedBy;
    }
    /**
     * Set TrackedBy value
     * @param \StructType\TrackedBy $trackedBy
     * @return \StructType\AWBInfo
     */
    public function setTrackedBy(\StructType\TrackedBy $trackedBy = null)
    {
        $this->TrackedBy = $trackedBy;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Status $status
     * @return \StructType\AWBInfo
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ShipmentInfo value
     * @return \StructType\ShipmentInfo|null
     */
    public function getShipmentInfo()
    {
        return $this->ShipmentInfo;
    }
    /**
     * Set ShipmentInfo value
     * @param \StructType\ShipmentInfo $shipmentInfo
     * @return \StructType\AWBInfo
     */
    public function setShipmentInfo(\StructType\ShipmentInfo $shipmentInfo = null)
    {
        $this->ShipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get Pieces value
     * @return \StructType\TrackingPieces|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param \StructType\TrackingPieces $pieces
     * @return \StructType\AWBInfo
     */
    public function setPieces(\StructType\TrackingPieces $pieces = null)
    {
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AWBInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
