<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentInfo StructType
 * @subpackage Structs
 */
class ShipmentInfo extends AbstractStructBase
{
    /**
     * The OriginServiceArea
     * @var \StructType\OriginServiceArea
     */
    public $OriginServiceArea;
    /**
     * The DestinationServiceArea
     * @var \StructType\DestinationServiceArea
     */
    public $DestinationServiceArea;
    /**
     * The ShipperName
     * Meta informations extracted from the WSDL
     * - maxLength: 45
     * - whiteSpace: preserve
     * @var string
     */
    public $ShipperName;
    /**
     * The ShipperAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 9999999999
     * - minInclusive: 100000000
     * @var int
     */
    public $ShipperAccountNumber;
    /**
     * The ConsigneeName
     * Meta informations extracted from the WSDL
     * - maxLength: 45
     * - whiteSpace: preserve
     * @var string
     */
    public $ConsigneeName;
    /**
     * The ShipmentDate
     * @var string
     */
    public $ShipmentDate;
    /**
     * The Pieces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Pieces;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The WeightUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WeightUnit;
    /**
     * The ShipmentEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShipmentEvent
     */
    public $ShipmentEvent;
    /**
     * The ShipperReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $ShipperReference;
    /**
     * The EstimatedDeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * Constructor method for ShipmentInfo
     * @uses ShipmentInfo::setOriginServiceArea()
     * @uses ShipmentInfo::setDestinationServiceArea()
     * @uses ShipmentInfo::setShipperName()
     * @uses ShipmentInfo::setShipperAccountNumber()
     * @uses ShipmentInfo::setConsigneeName()
     * @uses ShipmentInfo::setShipmentDate()
     * @uses ShipmentInfo::setPieces()
     * @uses ShipmentInfo::setWeight()
     * @uses ShipmentInfo::setWeightUnit()
     * @uses ShipmentInfo::setShipmentEvent()
     * @uses ShipmentInfo::setShipperReference()
     * @uses ShipmentInfo::setEstimatedDeliveryDate()
     * @param \StructType\OriginServiceArea $originServiceArea
     * @param \StructType\DestinationServiceArea $destinationServiceArea
     * @param string $shipperName
     * @param int $shipperAccountNumber
     * @param string $consigneeName
     * @param string $shipmentDate
     * @param string $pieces
     * @param string $weight
     * @param string $weightUnit
     * @param \ArrayType\ArrayOfShipmentEvent $shipmentEvent
     * @param \StructType\Reference $shipperReference
     * @param string $estimatedDeliveryDate
     */
    public function __construct(\StructType\OriginServiceArea $originServiceArea = null, \StructType\DestinationServiceArea $destinationServiceArea = null, $shipperName = null, $shipperAccountNumber = null, $consigneeName = null, $shipmentDate = null, $pieces = null, $weight = null, $weightUnit = null, \ArrayType\ArrayOfShipmentEvent $shipmentEvent = null, \StructType\Reference $shipperReference = null, $estimatedDeliveryDate = null)
    {
        $this
            ->setOriginServiceArea($originServiceArea)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setShipperName($shipperName)
            ->setShipperAccountNumber($shipperAccountNumber)
            ->setConsigneeName($consigneeName)
            ->setShipmentDate($shipmentDate)
            ->setPieces($pieces)
            ->setWeight($weight)
            ->setWeightUnit($weightUnit)
            ->setShipmentEvent($shipmentEvent)
            ->setShipperReference($shipperReference)
            ->setEstimatedDeliveryDate($estimatedDeliveryDate);
    }
    /**
     * Get OriginServiceArea value
     * @return \StructType\OriginServiceArea|null
     */
    public function getOriginServiceArea()
    {
        return $this->OriginServiceArea;
    }
    /**
     * Set OriginServiceArea value
     * @param \StructType\OriginServiceArea $originServiceArea
     * @return \StructType\ShipmentInfo
     */
    public function setOriginServiceArea(\StructType\OriginServiceArea $originServiceArea = null)
    {
        $this->OriginServiceArea = $originServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return \StructType\DestinationServiceArea|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param \StructType\DestinationServiceArea $destinationServiceArea
     * @return \StructType\ShipmentInfo
     */
    public function setDestinationServiceArea(\StructType\DestinationServiceArea $destinationServiceArea = null)
    {
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get ShipperName value
     * @return string|null
     */
    public function getShipperName()
    {
        return $this->ShipperName;
    }
    /**
     * Set ShipperName value
     * @param string $shipperName
     * @return \StructType\ShipmentInfo
     */
    public function setShipperName($shipperName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shipperName) && strlen($shipperName) > 45) || (is_array($shipperName) && count($shipperName) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($shipperName) ? strlen($shipperName) : count($shipperName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shipperName) && !is_string($shipperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipperName)), __LINE__);
        }
        $this->ShipperName = $shipperName;
        return $this;
    }
    /**
     * Get ShipperAccountNumber value
     * @return int|null
     */
    public function getShipperAccountNumber()
    {
        return $this->ShipperAccountNumber;
    }
    /**
     * Set ShipperAccountNumber value
     * @param int $shipperAccountNumber
     * @return \StructType\ShipmentInfo
     */
    public function setShipperAccountNumber($shipperAccountNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($shipperAccountNumber > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $shipperAccountNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($shipperAccountNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 100000000, "%s" given', $shipperAccountNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($shipperAccountNumber) && !is_numeric($shipperAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipperAccountNumber)), __LINE__);
        }
        $this->ShipperAccountNumber = $shipperAccountNumber;
        return $this;
    }
    /**
     * Get ConsigneeName value
     * @return string|null
     */
    public function getConsigneeName()
    {
        return $this->ConsigneeName;
    }
    /**
     * Set ConsigneeName value
     * @param string $consigneeName
     * @return \StructType\ShipmentInfo
     */
    public function setConsigneeName($consigneeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($consigneeName) && strlen($consigneeName) > 45) || (is_array($consigneeName) && count($consigneeName) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($consigneeName) ? strlen($consigneeName) : count($consigneeName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($consigneeName) && !is_string($consigneeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consigneeName)), __LINE__);
        }
        $this->ConsigneeName = $consigneeName;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \StructType\ShipmentInfo
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get Pieces value
     * @return string|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param string $pieces
     * @return \StructType\ShipmentInfo
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: string
        if (!is_null($pieces) && !is_string($pieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pieces)), __LINE__);
        }
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\ShipmentInfo
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @uses \EnumType\WeightUnit::valueIsValid()
     * @uses \EnumType\WeightUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightUnit
     * @return \StructType\ShipmentInfo
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeightUnit::valueIsValid($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $weightUnit, implode(', ', \EnumType\WeightUnit::getValidValues())), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get ShipmentEvent value
     * @return \ArrayType\ArrayOfShipmentEvent|null
     */
    public function getShipmentEvent()
    {
        return $this->ShipmentEvent;
    }
    /**
     * Set ShipmentEvent value
     * @param \ArrayType\ArrayOfShipmentEvent $shipmentEvent
     * @return \StructType\ShipmentInfo
     */
    public function setShipmentEvent(\ArrayType\ArrayOfShipmentEvent $shipmentEvent = null)
    {
        $this->ShipmentEvent = $shipmentEvent;
        return $this;
    }
    /**
     * Get ShipperReference value
     * @return \StructType\Reference|null
     */
    public function getShipperReference()
    {
        return $this->ShipperReference;
    }
    /**
     * Set ShipperReference value
     * @param \StructType\Reference $shipperReference
     * @return \StructType\ShipmentInfo
     */
    public function setShipperReference(\StructType\Reference $shipperReference = null)
    {
        $this->ShipperReference = $shipperReference;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \StructType\ShipmentInfo
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
