<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingRequest StructType
 * Meta informations extracted from the WSDL
 * - type: s0:TrackingRequest
 * @subpackage Structs
 */
class TrackingRequest extends AbstractStructBase
{
    /**
     * The Request
     * @var \StructType\Request
     */
    public $Request;
    /**
     * The AWBNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAWBNumber
     */
    public $AWBNumber;
    /**
     * The LPNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrackingPieceID
     */
    public $LPNumber;
    /**
     * The LevelOfDetails
     * @var string
     */
    public $LevelOfDetails;
    /**
     * The PiecesEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PiecesEnabled;
    /**
     * The EstimatedDeliveryDateEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EstimatedDeliveryDateEnabled;
    /**
     * Constructor method for TrackingRequest
     * @uses TrackingRequest::setRequest()
     * @uses TrackingRequest::setAWBNumber()
     * @uses TrackingRequest::setLPNumber()
     * @uses TrackingRequest::setLevelOfDetails()
     * @uses TrackingRequest::setPiecesEnabled()
     * @uses TrackingRequest::setEstimatedDeliveryDateEnabled()
     * @param \StructType\Request $request
     * @param \ArrayType\ArrayOfAWBNumber $aWBNumber
     * @param \ArrayType\ArrayOfTrackingPieceID $lPNumber
     * @param string $levelOfDetails
     * @param string $piecesEnabled
     * @param bool $estimatedDeliveryDateEnabled
     */
    public function __construct(\StructType\Request $request = null, \ArrayType\ArrayOfAWBNumber $aWBNumber = null, \ArrayType\ArrayOfTrackingPieceID $lPNumber = null, $levelOfDetails = null, $piecesEnabled = null, $estimatedDeliveryDateEnabled = null)
    {
        $this
            ->setRequest($request)
            ->setAWBNumber($aWBNumber)
            ->setLPNumber($lPNumber)
            ->setLevelOfDetails($levelOfDetails)
            ->setPiecesEnabled($piecesEnabled)
            ->setEstimatedDeliveryDateEnabled($estimatedDeliveryDateEnabled);
    }
    /**
     * Get Request value
     * @return \StructType\Request|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\Request $request
     * @return \StructType\TrackingRequest
     */
    public function setRequest(\StructType\Request $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get AWBNumber value
     * @return \ArrayType\ArrayOfAWBNumber|null
     */
    public function getAWBNumber()
    {
        return $this->AWBNumber;
    }
    /**
     * Set AWBNumber value
     * @param \ArrayType\ArrayOfAWBNumber $aWBNumber
     * @return \StructType\TrackingRequest
     */
    public function setAWBNumber(\ArrayType\ArrayOfAWBNumber $aWBNumber = null)
    {
        $this->AWBNumber = $aWBNumber;
        return $this;
    }
    /**
     * Get LPNumber value
     * @return \ArrayType\ArrayOfTrackingPieceID|null
     */
    public function getLPNumber()
    {
        return $this->LPNumber;
    }
    /**
     * Set LPNumber value
     * @param \ArrayType\ArrayOfTrackingPieceID $lPNumber
     * @return \StructType\TrackingRequest
     */
    public function setLPNumber(\ArrayType\ArrayOfTrackingPieceID $lPNumber = null)
    {
        $this->LPNumber = $lPNumber;
        return $this;
    }
    /**
     * Get LevelOfDetails value
     * @return string|null
     */
    public function getLevelOfDetails()
    {
        return $this->LevelOfDetails;
    }
    /**
     * Set LevelOfDetails value
     * @uses \EnumType\LevelOfDetails::valueIsValid()
     * @uses \EnumType\LevelOfDetails::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $levelOfDetails
     * @return \StructType\TrackingRequest
     */
    public function setLevelOfDetails($levelOfDetails = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LevelOfDetails::valueIsValid($levelOfDetails)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $levelOfDetails, implode(', ', \EnumType\LevelOfDetails::getValidValues())), __LINE__);
        }
        $this->LevelOfDetails = $levelOfDetails;
        return $this;
    }
    /**
     * Get PiecesEnabled value
     * @return string|null
     */
    public function getPiecesEnabled()
    {
        return $this->PiecesEnabled;
    }
    /**
     * Set PiecesEnabled value
     * @param string $piecesEnabled
     * @return \StructType\TrackingRequest
     */
    public function setPiecesEnabled($piecesEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($piecesEnabled) && !is_string($piecesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($piecesEnabled)), __LINE__);
        }
        $this->PiecesEnabled = $piecesEnabled;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDateEnabled value
     * @return bool|null
     */
    public function getEstimatedDeliveryDateEnabled()
    {
        return $this->EstimatedDeliveryDateEnabled;
    }
    /**
     * Set EstimatedDeliveryDateEnabled value
     * @param bool $estimatedDeliveryDateEnabled
     * @return \StructType\TrackingRequest
     */
    public function setEstimatedDeliveryDateEnabled($estimatedDeliveryDateEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($estimatedDeliveryDateEnabled) && !is_bool($estimatedDeliveryDateEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estimatedDeliveryDateEnabled)), __LINE__);
        }
        $this->EstimatedDeliveryDateEnabled = $estimatedDeliveryDateEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrackingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
