<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginServiceArea StructType
 * @subpackage Structs
 */
class OriginServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 3
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The OutboundSortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 4
     * - whiteSpace: preserve
     * @var string
     */
    public $OutboundSortCode;
    /**
     * Constructor method for OriginServiceArea
     * @uses OriginServiceArea::setServiceAreaCode()
     * @uses OriginServiceArea::setDescription()
     * @uses OriginServiceArea::setOutboundSortCode()
     * @param string $serviceAreaCode
     * @param string $description
     * @param string $outboundSortCode
     */
    public function __construct($serviceAreaCode = null, $description = null, $outboundSortCode = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description)
            ->setOutboundSortCode($outboundSortCode);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\OriginServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($serviceAreaCode) && strlen($serviceAreaCode) !== 3) || (is_array($serviceAreaCode) && count($serviceAreaCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OriginServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get OutboundSortCode value
     * @return string|null
     */
    public function getOutboundSortCode()
    {
        return $this->OutboundSortCode;
    }
    /**
     * Set OutboundSortCode value
     * @param string $outboundSortCode
     * @return \StructType\OriginServiceArea
     */
    public function setOutboundSortCode($outboundSortCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($outboundSortCode) && strlen($outboundSortCode) !== 4) || (is_array($outboundSortCode) && count($outboundSortCode) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($outboundSortCode) && !is_string($outboundSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outboundSortCode)), __LINE__);
        }
        $this->OutboundSortCode = $outboundSortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
