<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperReference StructType
 * @subpackage Structs
 */
class ShipperReference extends AbstractStructBase
{
    /**
     * The ReferenceID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReferenceID;
    /**
     * The ReferenceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceType;
    /**
     * Constructor method for ShipperReference
     * @uses ShipperReference::setReferenceID()
     * @uses ShipperReference::setReferenceType()
     * @param string $referenceID
     * @param string $referenceType
     */
    public function __construct($referenceID = null, $referenceType = null)
    {
        $this
            ->setReferenceID($referenceID)
            ->setReferenceType($referenceType);
    }
    /**
     * Get ReferenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param string $referenceID
     * @return \StructType\ShipperReference
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceID)), __LINE__);
        }
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get ReferenceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceType()
    {
        return isset($this->ReferenceType) ? $this->ReferenceType : null;
    }
    /**
     * Set ReferenceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceType
     * @return \StructType\ShipperReference
     */
    public function setReferenceType($referenceType = null)
    {
        // validation for constraint: string
        if (!is_null($referenceType) && !is_string($referenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceType)), __LINE__);
        }
        if (is_null($referenceType) || (is_array($referenceType) && empty($referenceType))) {
            unset($this->ReferenceType);
        } else {
            $this->ReferenceType = $referenceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipperReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
