<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceHeader StructType
 * @subpackage Structs
 */
class ServiceHeader extends AbstractStructBase
{
    /**
     * The MessageTime
     * @var string
     */
    public $MessageTime;
    /**
     * The MessageReference
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * - minLength: 28
     * - whiteSpace: preserve
     * @var string
     */
    public $MessageReference;
    /**
     * Constructor method for ServiceHeader
     * @uses ServiceHeader::setMessageTime()
     * @uses ServiceHeader::setMessageReference()
     * @param string $messageTime
     * @param string $messageReference
     */
    public function __construct($messageTime = null, $messageReference = null)
    {
        $this
            ->setMessageTime($messageTime)
            ->setMessageReference($messageReference);
    }
    /**
     * Get MessageTime value
     * @return string|null
     */
    public function getMessageTime()
    {
        return $this->MessageTime;
    }
    /**
     * Set MessageTime value
     * @param string $messageTime
     * @return \StructType\ServiceHeader
     */
    public function setMessageTime($messageTime = null)
    {
        // validation for constraint: string
        if (!is_null($messageTime) && !is_string($messageTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageTime)), __LINE__);
        }
        $this->MessageTime = $messageTime;
        return $this;
    }
    /**
     * Get MessageReference value
     * @return string|null
     */
    public function getMessageReference()
    {
        return $this->MessageReference;
    }
    /**
     * Set MessageReference value
     * @param string $messageReference
     * @return \StructType\ServiceHeader
     */
    public function setMessageReference($messageReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageReference) && strlen($messageReference) > 32) || (is_array($messageReference) && count($messageReference) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($messageReference) ? strlen($messageReference) : count($messageReference)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageReference) && strlen($messageReference) < 28) || (is_array($messageReference) && count($messageReference) < 28)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 28 element(s) or a scalar of 28 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageReference) && !is_string($messageReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReference)), __LINE__);
        }
        $this->MessageReference = $messageReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
