<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceEvent StructType
 * @subpackage Structs
 */
class ServiceEvent extends AbstractStructBase
{
    /**
     * The EventCode
     * Meta informations extracted from the WSDL
     * - length: 2
     * - whiteSpace: preserve
     * @var string
     */
    public $EventCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ServiceEvent
     * @uses ServiceEvent::setEventCode()
     * @uses ServiceEvent::setDescription()
     * @param string $eventCode
     * @param string $description
     */
    public function __construct($eventCode = null, $description = null)
    {
        $this
            ->setEventCode($eventCode)
            ->setDescription($description);
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\ServiceEvent
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($eventCode) && strlen($eventCode) !== 2) || (is_array($eventCode) && count($eventCode) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ServiceEvent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
