<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference StructType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The ReferenceID
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - whiteSpace: preserve
     * @var string
     */
    public $ReferenceID;
    /**
     * The ReferenceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 2
     * - whiteSpace: preserve
     * @var string
     */
    public $ReferenceType;
    /**
     * Constructor method for Reference
     * @uses Reference::setReferenceID()
     * @uses Reference::setReferenceType()
     * @param string $referenceID
     * @param string $referenceType
     */
    public function __construct($referenceID = null, $referenceType = null)
    {
        $this
            ->setReferenceID($referenceID)
            ->setReferenceType($referenceType);
    }
    /**
     * Get ReferenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param string $referenceID
     * @return \StructType\Reference
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceID) && strlen($referenceID) > 35) || (is_array($referenceID) && count($referenceID) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($referenceID) ? strlen($referenceID) : count($referenceID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceID)), __LINE__);
        }
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get ReferenceType value
     * @return string|null
     */
    public function getReferenceType()
    {
        return $this->ReferenceType;
    }
    /**
     * Set ReferenceType value
     * @param string $referenceType
     * @return \StructType\Reference
     */
    public function setReferenceType($referenceType = null)
    {
        // validation for constraint: length
        if ((is_scalar($referenceType) && strlen($referenceType) !== 2) || (is_array($referenceType) && count($referenceType) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceType) && !is_string($referenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceType)), __LINE__);
        }
        $this->ReferenceType = $referenceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Reference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
