<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCondition ArrayType
 * @subpackage Arrays
 */
class ArrayOfCondition extends AbstractStructArrayBase
{
    /**
     * The ArrayOfConditionItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Condition[]
     */
    public $ArrayOfConditionItem;
    /**
     * Constructor method for ArrayOfCondition
     * @uses ArrayOfCondition::setArrayOfConditionItem()
     * @param \StructType\Condition[] $arrayOfConditionItem
     */
    public function __construct(array $arrayOfConditionItem = array())
    {
        $this
            ->setArrayOfConditionItem($arrayOfConditionItem);
    }
    /**
     * Get ArrayOfConditionItem value
     * @return \StructType\Condition[]|null
     */
    public function getArrayOfConditionItem()
    {
        return $this->ArrayOfConditionItem;
    }
    /**
     * Set ArrayOfConditionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition[] $arrayOfConditionItem
     * @return \ArrayType\ArrayOfCondition
     */
    public function setArrayOfConditionItem(array $arrayOfConditionItem = array())
    {
        foreach ($arrayOfConditionItem as $arrayOfConditionArrayOfConditionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfConditionArrayOfConditionItemItem instanceof \StructType\Condition) {
                throw new \InvalidArgumentException(sprintf('The ArrayOfConditionItem property can only contain items of \StructType\Condition, "%s" given', is_object($arrayOfConditionArrayOfConditionItemItem) ? get_class($arrayOfConditionArrayOfConditionItemItem) : gettype($arrayOfConditionArrayOfConditionItemItem)), __LINE__);
            }
        }
        $this->ArrayOfConditionItem = $arrayOfConditionItem;
        return $this;
    }
    /**
     * Add item to ArrayOfConditionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition $item
     * @return \ArrayType\ArrayOfCondition
     */
    public function addToArrayOfConditionItem(\StructType\Condition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Condition) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfConditionItem property can only contain items of \StructType\Condition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrayOfConditionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Condition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Condition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Condition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Condition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Condition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfConditionItem
     */
    public function getAttributeName()
    {
        return 'ArrayOfConditionItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCondition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
