<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAWBNumber ArrayType
 * @subpackage Arrays
 */
class ArrayOfAWBNumber extends AbstractStructArrayBase
{
    /**
     * The ArrayOfAWBNumberItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - maxLength: 11
     * - minLength: 10
     * - whiteSpace: preserve
     * @var string[]
     */
    public $ArrayOfAWBNumberItem;
    /**
     * Constructor method for ArrayOfAWBNumber
     * @uses ArrayOfAWBNumber::setArrayOfAWBNumberItem()
     * @param string[] $arrayOfAWBNumberItem
     */
    public function __construct(array $arrayOfAWBNumberItem = array())
    {
        $this
            ->setArrayOfAWBNumberItem($arrayOfAWBNumberItem);
    }
    /**
     * Get ArrayOfAWBNumberItem value
     * @return string[]|null
     */
    public function getArrayOfAWBNumberItem()
    {
        return $this->ArrayOfAWBNumberItem;
    }
    /**
     * Set ArrayOfAWBNumberItem value
     * @throws \InvalidArgumentException
     * @param string[] $arrayOfAWBNumberItem
     * @return \ArrayType\ArrayOfAWBNumber
     */
    public function setArrayOfAWBNumberItem(array $arrayOfAWBNumberItem = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($arrayOfAWBNumberItem) && strlen($arrayOfAWBNumberItem) > 11) || (is_array($arrayOfAWBNumberItem) && count($arrayOfAWBNumberItem) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($arrayOfAWBNumberItem) ? strlen($arrayOfAWBNumberItem) : count($arrayOfAWBNumberItem)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($arrayOfAWBNumberItem) && strlen($arrayOfAWBNumberItem) < 10) || (is_array($arrayOfAWBNumberItem) && count($arrayOfAWBNumberItem) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        foreach ($arrayOfAWBNumberItem as $arrayOfAWBNumberArrayOfAWBNumberItemItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfAWBNumberArrayOfAWBNumberItemItem)) {
                throw new \InvalidArgumentException(sprintf('The ArrayOfAWBNumberItem property can only contain items of string, "%s" given', is_object($arrayOfAWBNumberArrayOfAWBNumberItemItem) ? get_class($arrayOfAWBNumberArrayOfAWBNumberItemItem) : gettype($arrayOfAWBNumberArrayOfAWBNumberItemItem)), __LINE__);
            }
        }
        $this->ArrayOfAWBNumberItem = $arrayOfAWBNumberItem;
        return $this;
    }
    /**
     * Add item to ArrayOfAWBNumberItem value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfAWBNumber
     */
    public function addToArrayOfAWBNumberItem($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 11) || (is_array($item) && count($item) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 10) || (is_array($item) && count($item) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfAWBNumberItem property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrayOfAWBNumberItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfAWBNumberItem
     */
    public function getAttributeName()
    {
        return 'ArrayOfAWBNumberItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAWBNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
