<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceEvent StructType
 * @subpackage Structs
 */
class PieceEvent extends AbstractStructBase
{
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The ServiceEvent
     * @var \StructType\ServiceEvent
     */
    public $ServiceEvent;
    /**
     * The Signatory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $Signatory;
    /**
     * The ServiceArea
     * @var \StructType\ServiceArea
     */
    public $ServiceArea;
    /**
     * The ShipperReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ShipperReference
     */
    public $ShipperReference;
    /**
     * Constructor method for PieceEvent
     * @uses PieceEvent::setDate()
     * @uses PieceEvent::setTime()
     * @uses PieceEvent::setServiceEvent()
     * @uses PieceEvent::setSignatory()
     * @uses PieceEvent::setServiceArea()
     * @uses PieceEvent::setShipperReference()
     * @param string $date
     * @param string $time
     * @param \StructType\ServiceEvent $serviceEvent
     * @param string $signatory
     * @param \StructType\ServiceArea $serviceArea
     * @param \StructType\ShipperReference $shipperReference
     */
    public function __construct($date = null, $time = null, \StructType\ServiceEvent $serviceEvent = null, $signatory = null, \StructType\ServiceArea $serviceArea = null, \StructType\ShipperReference $shipperReference = null)
    {
        $this
            ->setDate($date)
            ->setTime($time)
            ->setServiceEvent($serviceEvent)
            ->setSignatory($signatory)
            ->setServiceArea($serviceArea)
            ->setShipperReference($shipperReference);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PieceEvent
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\PieceEvent
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get ServiceEvent value
     * @return \StructType\ServiceEvent|null
     */
    public function getServiceEvent()
    {
        return $this->ServiceEvent;
    }
    /**
     * Set ServiceEvent value
     * @param \StructType\ServiceEvent $serviceEvent
     * @return \StructType\PieceEvent
     */
    public function setServiceEvent(\StructType\ServiceEvent $serviceEvent = null)
    {
        $this->ServiceEvent = $serviceEvent;
        return $this;
    }
    /**
     * Get Signatory value
     * @return string|null
     */
    public function getSignatory()
    {
        return $this->Signatory;
    }
    /**
     * Set Signatory value
     * @param string $signatory
     * @return \StructType\PieceEvent
     */
    public function setSignatory($signatory = null)
    {
        // validation for constraint: string
        if (!is_null($signatory) && !is_string($signatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatory)), __LINE__);
        }
        $this->Signatory = $signatory;
        return $this;
    }
    /**
     * Get ServiceArea value
     * @return \StructType\ServiceArea|null
     */
    public function getServiceArea()
    {
        return $this->ServiceArea;
    }
    /**
     * Set ServiceArea value
     * @param \StructType\ServiceArea $serviceArea
     * @return \StructType\PieceEvent
     */
    public function setServiceArea(\StructType\ServiceArea $serviceArea = null)
    {
        $this->ServiceArea = $serviceArea;
        return $this;
    }
    /**
     * Get ShipperReference value
     * @return \StructType\ShipperReference|null
     */
    public function getShipperReference()
    {
        return $this->ShipperReference;
    }
    /**
     * Set ShipperReference value
     * @param \StructType\ShipperReference $shipperReference
     * @return \StructType\PieceEvent
     */
    public function setShipperReference(\StructType\ShipperReference $shipperReference = null)
    {
        $this->ShipperReference = $shipperReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PieceEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
