<?php

namespace EnumType;

/**
 * This class stands for WeightUnit EnumType
 * @subpackage Enumerations
 */
class WeightUnit
{
    /**
     * Constant for value 'L'
     * @return string 'L'
     */
    const VALUE_L = 'L';
    /**
     * Constant for value 'K'
     * @return string 'K'
     */
    const VALUE_K = 'K';
    /**
     * Constant for value 'G'
     * @return string 'G'
     */
    const VALUE_G = 'G';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_L
     * @uses self::VALUE_K
     * @uses self::VALUE_G
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_L,
            self::VALUE_K,
            self::VALUE_G,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
