<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The ActionStatus
     * @var string
     */
    public $ActionStatus;
    /**
     * The Condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCondition
     */
    public $Condition;
    /**
     * Constructor method for Status
     * @uses Status::setActionStatus()
     * @uses Status::setCondition()
     * @param string $actionStatus
     * @param \ArrayType\ArrayOfCondition $condition
     */
    public function __construct($actionStatus = null, \ArrayType\ArrayOfCondition $condition = null)
    {
        $this
            ->setActionStatus($actionStatus)
            ->setCondition($condition);
    }
    /**
     * Get ActionStatus value
     * @return string|null
     */
    public function getActionStatus()
    {
        return $this->ActionStatus;
    }
    /**
     * Set ActionStatus value
     * @param string $actionStatus
     * @return \StructType\Status
     */
    public function setActionStatus($actionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($actionStatus) && !is_string($actionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionStatus)), __LINE__);
        }
        $this->ActionStatus = $actionStatus;
        return $this;
    }
    /**
     * Get Condition value
     * @return \ArrayType\ArrayOfCondition|null
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @param \ArrayType\ArrayOfCondition $condition
     * @return \StructType\Status
     */
    public function setCondition(\ArrayType\ArrayOfCondition $condition = null)
    {
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
