<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceArea StructType
 * @subpackage Structs
 */
class ServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 3
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ServiceArea
     * @uses ServiceArea::setServiceAreaCode()
     * @uses ServiceArea::setDescription()
     * @param string $serviceAreaCode
     * @param string $description
     */
    public function __construct($serviceAreaCode = null, $description = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\ServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($serviceAreaCode) && strlen($serviceAreaCode) !== 3) || (is_array($serviceAreaCode) && count($serviceAreaCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
