<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceDetails StructType
 * @subpackage Structs
 */
class PieceDetails extends AbstractStructBase
{
    /**
     * The AWBNumber
     * @var string
     */
    public $AWBNumber;
    /**
     * The LicensePlate
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: preserve
     * @var string
     */
    public $LicensePlate;
    /**
     * The PieceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PieceNumber;
    /**
     * The ActualDepth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualDepth;
    /**
     * The ActualWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualWidth;
    /**
     * The ActualHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualHeight;
    /**
     * The ActualWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualWeight;
    /**
     * The Depth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Depth;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Width;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Height;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The PackageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * - whiteSpace: preserve
     * @var string
     */
    public $PackageType;
    /**
     * The DimWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DimWeight;
    /**
     * The WeightUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WeightUnit;
    /**
     * The PieceContents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PieceContents;
    /**
     * Constructor method for PieceDetails
     * @uses PieceDetails::setAWBNumber()
     * @uses PieceDetails::setLicensePlate()
     * @uses PieceDetails::setPieceNumber()
     * @uses PieceDetails::setActualDepth()
     * @uses PieceDetails::setActualWidth()
     * @uses PieceDetails::setActualHeight()
     * @uses PieceDetails::setActualWeight()
     * @uses PieceDetails::setDepth()
     * @uses PieceDetails::setWidth()
     * @uses PieceDetails::setHeight()
     * @uses PieceDetails::setWeight()
     * @uses PieceDetails::setPackageType()
     * @uses PieceDetails::setDimWeight()
     * @uses PieceDetails::setWeightUnit()
     * @uses PieceDetails::setPieceContents()
     * @param string $aWBNumber
     * @param string $licensePlate
     * @param string $pieceNumber
     * @param string $actualDepth
     * @param string $actualWidth
     * @param string $actualHeight
     * @param string $actualWeight
     * @param string $depth
     * @param string $width
     * @param string $height
     * @param string $weight
     * @param string $packageType
     * @param string $dimWeight
     * @param string $weightUnit
     * @param string $pieceContents
     */
    public function __construct($aWBNumber = null, $licensePlate = null, $pieceNumber = null, $actualDepth = null, $actualWidth = null, $actualHeight = null, $actualWeight = null, $depth = null, $width = null, $height = null, $weight = null, $packageType = null, $dimWeight = null, $weightUnit = null, $pieceContents = null)
    {
        $this
            ->setAWBNumber($aWBNumber)
            ->setLicensePlate($licensePlate)
            ->setPieceNumber($pieceNumber)
            ->setActualDepth($actualDepth)
            ->setActualWidth($actualWidth)
            ->setActualHeight($actualHeight)
            ->setActualWeight($actualWeight)
            ->setDepth($depth)
            ->setWidth($width)
            ->setHeight($height)
            ->setWeight($weight)
            ->setPackageType($packageType)
            ->setDimWeight($dimWeight)
            ->setWeightUnit($weightUnit)
            ->setPieceContents($pieceContents);
    }
    /**
     * Get AWBNumber value
     * @return string|null
     */
    public function getAWBNumber()
    {
        return $this->AWBNumber;
    }
    /**
     * Set AWBNumber value
     * @param string $aWBNumber
     * @return \StructType\PieceDetails
     */
    public function setAWBNumber($aWBNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aWBNumber) && !is_string($aWBNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aWBNumber)), __LINE__);
        }
        $this->AWBNumber = $aWBNumber;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\PieceDetails
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($licensePlate) && strlen($licensePlate) > 35) || (is_array($licensePlate) && count($licensePlate) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($licensePlate) ? strlen($licensePlate) : count($licensePlate)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($licensePlate) && strlen($licensePlate) < 1) || (is_array($licensePlate) && count($licensePlate) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get PieceNumber value
     * @return string|null
     */
    public function getPieceNumber()
    {
        return $this->PieceNumber;
    }
    /**
     * Set PieceNumber value
     * @param string $pieceNumber
     * @return \StructType\PieceDetails
     */
    public function setPieceNumber($pieceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pieceNumber) && !is_string($pieceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pieceNumber)), __LINE__);
        }
        $this->PieceNumber = $pieceNumber;
        return $this;
    }
    /**
     * Get ActualDepth value
     * @return string|null
     */
    public function getActualDepth()
    {
        return $this->ActualDepth;
    }
    /**
     * Set ActualDepth value
     * @param string $actualDepth
     * @return \StructType\PieceDetails
     */
    public function setActualDepth($actualDepth = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepth) && !is_string($actualDepth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDepth)), __LINE__);
        }
        $this->ActualDepth = $actualDepth;
        return $this;
    }
    /**
     * Get ActualWidth value
     * @return string|null
     */
    public function getActualWidth()
    {
        return $this->ActualWidth;
    }
    /**
     * Set ActualWidth value
     * @param string $actualWidth
     * @return \StructType\PieceDetails
     */
    public function setActualWidth($actualWidth = null)
    {
        // validation for constraint: string
        if (!is_null($actualWidth) && !is_string($actualWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualWidth)), __LINE__);
        }
        $this->ActualWidth = $actualWidth;
        return $this;
    }
    /**
     * Get ActualHeight value
     * @return string|null
     */
    public function getActualHeight()
    {
        return $this->ActualHeight;
    }
    /**
     * Set ActualHeight value
     * @param string $actualHeight
     * @return \StructType\PieceDetails
     */
    public function setActualHeight($actualHeight = null)
    {
        // validation for constraint: string
        if (!is_null($actualHeight) && !is_string($actualHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualHeight)), __LINE__);
        }
        $this->ActualHeight = $actualHeight;
        return $this;
    }
    /**
     * Get ActualWeight value
     * @return string|null
     */
    public function getActualWeight()
    {
        return $this->ActualWeight;
    }
    /**
     * Set ActualWeight value
     * @param string $actualWeight
     * @return \StructType\PieceDetails
     */
    public function setActualWeight($actualWeight = null)
    {
        // validation for constraint: string
        if (!is_null($actualWeight) && !is_string($actualWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualWeight)), __LINE__);
        }
        $this->ActualWeight = $actualWeight;
        return $this;
    }
    /**
     * Get Depth value
     * @return string|null
     */
    public function getDepth()
    {
        return $this->Depth;
    }
    /**
     * Set Depth value
     * @param string $depth
     * @return \StructType\PieceDetails
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: string
        if (!is_null($depth) && !is_string($depth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depth)), __LINE__);
        }
        $this->Depth = $depth;
        return $this;
    }
    /**
     * Get Width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param string $width
     * @return \StructType\PieceDetails
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return string|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param string $height
     * @return \StructType\PieceDetails
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\PieceDetails
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \StructType\PieceDetails
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($packageType) && strlen($packageType) > 3) || (is_array($packageType) && count($packageType) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($packageType) ? strlen($packageType) : count($packageType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get DimWeight value
     * @return string|null
     */
    public function getDimWeight()
    {
        return $this->DimWeight;
    }
    /**
     * Set DimWeight value
     * @param string $dimWeight
     * @return \StructType\PieceDetails
     */
    public function setDimWeight($dimWeight = null)
    {
        // validation for constraint: string
        if (!is_null($dimWeight) && !is_string($dimWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dimWeight)), __LINE__);
        }
        $this->DimWeight = $dimWeight;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @param string $weightUnit
     * @return \StructType\PieceDetails
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnit) && !is_string($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weightUnit)), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get PieceContents value
     * @return string|null
     */
    public function getPieceContents()
    {
        return $this->PieceContents;
    }
    /**
     * Set PieceContents value
     * @param string $pieceContents
     * @return \StructType\PieceDetails
     */
    public function setPieceContents($pieceContents = null)
    {
        // validation for constraint: string
        if (!is_null($pieceContents) && !is_string($pieceContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pieceContents)), __LINE__);
        }
        $this->PieceContents = $pieceContents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PieceDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
