<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationServiceArea StructType
 * @subpackage Structs
 */
class DestinationServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 3
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FacilityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * - whiteSpace: preserve
     * @var string
     */
    public $FacilityCode;
    /**
     * The InboundSortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 4
     * - whiteSpace: preserve
     * @var string
     */
    public $InboundSortCode;
    /**
     * Constructor method for DestinationServiceArea
     * @uses DestinationServiceArea::setServiceAreaCode()
     * @uses DestinationServiceArea::setDescription()
     * @uses DestinationServiceArea::setFacilityCode()
     * @uses DestinationServiceArea::setInboundSortCode()
     * @param string $serviceAreaCode
     * @param string $description
     * @param string $facilityCode
     * @param string $inboundSortCode
     */
    public function __construct($serviceAreaCode = null, $description = null, $facilityCode = null, $inboundSortCode = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description)
            ->setFacilityCode($facilityCode)
            ->setInboundSortCode($inboundSortCode);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\DestinationServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($serviceAreaCode) && strlen($serviceAreaCode) !== 3) || (is_array($serviceAreaCode) && count($serviceAreaCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DestinationServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\DestinationServiceArea
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($facilityCode) && strlen($facilityCode) > 3) || (is_array($facilityCode) && count($facilityCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($facilityCode) ? strlen($facilityCode) : count($facilityCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get InboundSortCode value
     * @return string|null
     */
    public function getInboundSortCode()
    {
        return $this->InboundSortCode;
    }
    /**
     * Set InboundSortCode value
     * @param string $inboundSortCode
     * @return \StructType\DestinationServiceArea
     */
    public function setInboundSortCode($inboundSortCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($inboundSortCode) && strlen($inboundSortCode) !== 4) || (is_array($inboundSortCode) && count($inboundSortCode) !== 4)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inboundSortCode) && !is_string($inboundSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inboundSortCode)), __LINE__);
        }
        $this->InboundSortCode = $inboundSortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
