<?php

namespace EnumType;

/**
 * This class stands for LevelOfDetails EnumType
 * @subpackage Enumerations
 */
class LevelOfDetails
{
    /**
     * Constant for value 'LAST_CHECK_POINT_ONLY'
     * @return string 'LAST_CHECK_POINT_ONLY'
     */
    const VALUE_LAST_CHECK_POINT_ONLY = 'LAST_CHECK_POINT_ONLY';
    /**
     * Constant for value 'ALL_CHECK_POINTS'
     * @return string 'ALL_CHECK_POINTS'
     */
    const VALUE_ALL_CHECK_POINTS = 'ALL_CHECK_POINTS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAST_CHECK_POINT_ONLY
     * @uses self::VALUE_ALL_CHECK_POINTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAST_CHECK_POINT_ONLY,
            self::VALUE_ALL_CHECK_POINTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
