<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrackingPieceID ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrackingPieceID extends AbstractStructArrayBase
{
    /**
     * The ArrayOfTrackingPieceIDItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: preserve
     * @var string[]
     */
    public $ArrayOfTrackingPieceIDItem;
    /**
     * Constructor method for ArrayOfTrackingPieceID
     * @uses ArrayOfTrackingPieceID::setArrayOfTrackingPieceIDItem()
     * @param string[] $arrayOfTrackingPieceIDItem
     */
    public function __construct(array $arrayOfTrackingPieceIDItem = array())
    {
        $this
            ->setArrayOfTrackingPieceIDItem($arrayOfTrackingPieceIDItem);
    }
    /**
     * Get ArrayOfTrackingPieceIDItem value
     * @return string[]|null
     */
    public function getArrayOfTrackingPieceIDItem()
    {
        return $this->ArrayOfTrackingPieceIDItem;
    }
    /**
     * Set ArrayOfTrackingPieceIDItem value
     * @throws \InvalidArgumentException
     * @param string[] $arrayOfTrackingPieceIDItem
     * @return \ArrayType\ArrayOfTrackingPieceID
     */
    public function setArrayOfTrackingPieceIDItem(array $arrayOfTrackingPieceIDItem = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($arrayOfTrackingPieceIDItem) && strlen($arrayOfTrackingPieceIDItem) > 35) || (is_array($arrayOfTrackingPieceIDItem) && count($arrayOfTrackingPieceIDItem) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($arrayOfTrackingPieceIDItem) ? strlen($arrayOfTrackingPieceIDItem) : count($arrayOfTrackingPieceIDItem)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($arrayOfTrackingPieceIDItem) && strlen($arrayOfTrackingPieceIDItem) < 1) || (is_array($arrayOfTrackingPieceIDItem) && count($arrayOfTrackingPieceIDItem) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($arrayOfTrackingPieceIDItem as $arrayOfTrackingPieceIDArrayOfTrackingPieceIDItemItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfTrackingPieceIDArrayOfTrackingPieceIDItemItem)) {
                throw new \InvalidArgumentException(sprintf('The ArrayOfTrackingPieceIDItem property can only contain items of string, "%s" given', is_object($arrayOfTrackingPieceIDArrayOfTrackingPieceIDItemItem) ? get_class($arrayOfTrackingPieceIDArrayOfTrackingPieceIDItemItem) : gettype($arrayOfTrackingPieceIDArrayOfTrackingPieceIDItemItem)), __LINE__);
            }
        }
        $this->ArrayOfTrackingPieceIDItem = $arrayOfTrackingPieceIDItem;
        return $this;
    }
    /**
     * Add item to ArrayOfTrackingPieceIDItem value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfTrackingPieceID
     */
    public function addToArrayOfTrackingPieceIDItem($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 35) || (is_array($item) && count($item) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfTrackingPieceIDItem property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrayOfTrackingPieceIDItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfTrackingPieceIDItem
     */
    public function getAttributeName()
    {
        return 'ArrayOfTrackingPieceIDItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTrackingPieceID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
