<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.ed2go.com/sandbox/api/4.1/CatalogManagerService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.ed2go.com/sandbox/api/4.1/CatalogManagerService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \CatalogMgmt\Get($options);
/**
 * Sample call for GetCoursesBySectionNumber operation/method
 */
if ($get->GetCoursesBySectionNumber(new \StructType\GetCoursesBySectionNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCourseStandardPrices operation/method
 */
if ($get->GetCourseStandardPrices(new \StructType\GetCourseStandardPrices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOfferedCoursePrices operation/method
 */
if ($get->GetOfferedCoursePrices(new \StructType\GetOfferedCoursePrices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOfferedCourses operation/method
 */
if ($get->GetOfferedCourses(new \StructType\GetOfferedCourses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSettings operation/method
 */
if ($get->GetSettings(new \StructType\GetSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUnofferedCourses operation/method
 */
if ($get->GetUnofferedCourses(new \StructType\GetUnofferedCourses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \CatalogMgmt\Remove($options);
/**
 * Sample call for RemoveOfferedCourses operation/method
 */
if ($remove->RemoveOfferedCourses(new \StructType\RemoveOfferedCourses()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \CatalogMgmt\Set($options);
/**
 * Sample call for SetCoursePrice operation/method
 */
if ($set->SetCoursePrice(new \StructType\SetCoursePrice()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCourseSectionNumber operation/method
 */
if ($set->SetCourseSectionNumber(new \StructType\SetCourseSectionNumber()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
