<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCourseSectionNumber StructType
 * @subpackage Structs
 */
class SetCourseSectionNumber extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseCode;
    /**
     * The SectionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SectionNumber;
    /**
     * The EffectiveMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveMonth;
    /**
     * Constructor method for SetCourseSectionNumber
     * @uses SetCourseSectionNumber::setAPIKey()
     * @uses SetCourseSectionNumber::setCourseCode()
     * @uses SetCourseSectionNumber::setSectionNumber()
     * @uses SetCourseSectionNumber::setEffectiveMonth()
     * @param string $aPIKey
     * @param string $courseCode
     * @param string $sectionNumber
     * @param string $effectiveMonth
     */
    public function __construct($aPIKey = null, $courseCode = null, $sectionNumber = null, $effectiveMonth = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setCourseCode($courseCode)
            ->setSectionNumber($sectionNumber)
            ->setEffectiveMonth($effectiveMonth);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\SetCourseSectionNumber
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\SetCourseSectionNumber
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get SectionNumber value
     * @return string|null
     */
    public function getSectionNumber()
    {
        return $this->SectionNumber;
    }
    /**
     * Set SectionNumber value
     * @param string $sectionNumber
     * @return \StructType\SetCourseSectionNumber
     */
    public function setSectionNumber($sectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sectionNumber) && !is_string($sectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sectionNumber)), __LINE__);
        }
        $this->SectionNumber = $sectionNumber;
        return $this;
    }
    /**
     * Get EffectiveMonth value
     * @return string|null
     */
    public function getEffectiveMonth()
    {
        return $this->EffectiveMonth;
    }
    /**
     * Set EffectiveMonth value
     * @param string $effectiveMonth
     * @return \StructType\SetCourseSectionNumber
     */
    public function setEffectiveMonth($effectiveMonth = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMonth) && !is_string($effectiveMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveMonth)), __LINE__);
        }
        $this->EffectiveMonth = $effectiveMonth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCourseSectionNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
