<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCoursePrice StructType
 * @subpackage Structs
 */
class SetCoursePrice extends AbstractStructBase
{
    /**
     * The RetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RetailPrice;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseCode;
    /**
     * The EffectiveMonthRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MonthRange
     */
    public $EffectiveMonthRange;
    /**
     * Constructor method for SetCoursePrice
     * @uses SetCoursePrice::setRetailPrice()
     * @uses SetCoursePrice::setAPIKey()
     * @uses SetCoursePrice::setCourseCode()
     * @uses SetCoursePrice::setEffectiveMonthRange()
     * @param float $retailPrice
     * @param string $aPIKey
     * @param string $courseCode
     * @param \StructType\MonthRange $effectiveMonthRange
     */
    public function __construct($retailPrice = null, $aPIKey = null, $courseCode = null, \StructType\MonthRange $effectiveMonthRange = null)
    {
        $this
            ->setRetailPrice($retailPrice)
            ->setAPIKey($aPIKey)
            ->setCourseCode($courseCode)
            ->setEffectiveMonthRange($effectiveMonthRange);
    }
    /**
     * Get RetailPrice value
     * @return float
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param float $retailPrice
     * @return \StructType\SetCoursePrice
     */
    public function setRetailPrice($retailPrice = null)
    {
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\SetCoursePrice
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\SetCoursePrice
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get EffectiveMonthRange value
     * @return \StructType\MonthRange|null
     */
    public function getEffectiveMonthRange()
    {
        return $this->EffectiveMonthRange;
    }
    /**
     * Set EffectiveMonthRange value
     * @param \StructType\MonthRange $effectiveMonthRange
     * @return \StructType\SetCoursePrice
     */
    public function setEffectiveMonthRange(\StructType\MonthRange $effectiveMonthRange = null)
    {
        $this->EffectiveMonthRange = $effectiveMonthRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCoursePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
