<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveOfferedCourses StructType
 * @subpackage Structs
 */
class RemoveOfferedCourses extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The CourseCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $CourseCodes;
    /**
     * The EffectiveMonthRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MonthRange
     */
    public $EffectiveMonthRange;
    /**
     * Constructor method for RemoveOfferedCourses
     * @uses RemoveOfferedCourses::setAPIKey()
     * @uses RemoveOfferedCourses::setCourseCodes()
     * @uses RemoveOfferedCourses::setEffectiveMonthRange()
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfString $courseCodes
     * @param \StructType\MonthRange $effectiveMonthRange
     */
    public function __construct($aPIKey = null, \ArrayType\ArrayOfString $courseCodes = null, \StructType\MonthRange $effectiveMonthRange = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setCourseCodes($courseCodes)
            ->setEffectiveMonthRange($effectiveMonthRange);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\RemoveOfferedCourses
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get CourseCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCourseCodes()
    {
        return $this->CourseCodes;
    }
    /**
     * Set CourseCodes value
     * @param \ArrayType\ArrayOfString $courseCodes
     * @return \StructType\RemoveOfferedCourses
     */
    public function setCourseCodes(\ArrayType\ArrayOfString $courseCodes = null)
    {
        $this->CourseCodes = $courseCodes;
        return $this;
    }
    /**
     * Get EffectiveMonthRange value
     * @return \StructType\MonthRange|null
     */
    public function getEffectiveMonthRange()
    {
        return $this->EffectiveMonthRange;
    }
    /**
     * Set EffectiveMonthRange value
     * @param \StructType\MonthRange $effectiveMonthRange
     * @return \StructType\RemoveOfferedCourses
     */
    public function setEffectiveMonthRange(\StructType\MonthRange $effectiveMonthRange = null)
    {
        $this->EffectiveMonthRange = $effectiveMonthRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveOfferedCourses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
