<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceSettingsResponse StructType
 * @subpackage Structs
 */
class PriceSettingsResponse extends AbstractStructBase
{
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The RetailPriceCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RetailPriceCurrency;
    /**
     * The WholesalePriceCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WholesalePriceCurrency;
    /**
     * The SuggestedRetailPriceCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuggestedRetailPriceCurrency;
    /**
     * Constructor method for PriceSettingsResponse
     * @uses PriceSettingsResponse::setResult()
     * @uses PriceSettingsResponse::setRetailPriceCurrency()
     * @uses PriceSettingsResponse::setWholesalePriceCurrency()
     * @uses PriceSettingsResponse::setSuggestedRetailPriceCurrency()
     * @param \StructType\Result $result
     * @param string $retailPriceCurrency
     * @param string $wholesalePriceCurrency
     * @param string $suggestedRetailPriceCurrency
     */
    public function __construct(\StructType\Result $result = null, $retailPriceCurrency = null, $wholesalePriceCurrency = null, $suggestedRetailPriceCurrency = null)
    {
        $this
            ->setResult($result)
            ->setRetailPriceCurrency($retailPriceCurrency)
            ->setWholesalePriceCurrency($wholesalePriceCurrency)
            ->setSuggestedRetailPriceCurrency($suggestedRetailPriceCurrency);
    }
    /**
     * Get Result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\PriceSettingsResponse
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get RetailPriceCurrency value
     * @return string|null
     */
    public function getRetailPriceCurrency()
    {
        return $this->RetailPriceCurrency;
    }
    /**
     * Set RetailPriceCurrency value
     * @param string $retailPriceCurrency
     * @return \StructType\PriceSettingsResponse
     */
    public function setRetailPriceCurrency($retailPriceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($retailPriceCurrency) && !is_string($retailPriceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retailPriceCurrency)), __LINE__);
        }
        $this->RetailPriceCurrency = $retailPriceCurrency;
        return $this;
    }
    /**
     * Get WholesalePriceCurrency value
     * @return string|null
     */
    public function getWholesalePriceCurrency()
    {
        return $this->WholesalePriceCurrency;
    }
    /**
     * Set WholesalePriceCurrency value
     * @param string $wholesalePriceCurrency
     * @return \StructType\PriceSettingsResponse
     */
    public function setWholesalePriceCurrency($wholesalePriceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($wholesalePriceCurrency) && !is_string($wholesalePriceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wholesalePriceCurrency)), __LINE__);
        }
        $this->WholesalePriceCurrency = $wholesalePriceCurrency;
        return $this;
    }
    /**
     * Get SuggestedRetailPriceCurrency value
     * @return string|null
     */
    public function getSuggestedRetailPriceCurrency()
    {
        return $this->SuggestedRetailPriceCurrency;
    }
    /**
     * Set SuggestedRetailPriceCurrency value
     * @param string $suggestedRetailPriceCurrency
     * @return \StructType\PriceSettingsResponse
     */
    public function setSuggestedRetailPriceCurrency($suggestedRetailPriceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($suggestedRetailPriceCurrency) && !is_string($suggestedRetailPriceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suggestedRetailPriceCurrency)), __LINE__);
        }
        $this->SuggestedRetailPriceCurrency = $suggestedRetailPriceCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceSettingsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
