<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthRange StructType
 * @subpackage Structs
 */
class MonthRange extends AbstractStructBase
{
    /**
     * The RangeStartMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RangeStartMonth;
    /**
     * The RangeEndMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RangeEndMonth;
    /**
     * Constructor method for MonthRange
     * @uses MonthRange::setRangeStartMonth()
     * @uses MonthRange::setRangeEndMonth()
     * @param string $rangeStartMonth
     * @param string $rangeEndMonth
     */
    public function __construct($rangeStartMonth = null, $rangeEndMonth = null)
    {
        $this
            ->setRangeStartMonth($rangeStartMonth)
            ->setRangeEndMonth($rangeEndMonth);
    }
    /**
     * Get RangeStartMonth value
     * @return string|null
     */
    public function getRangeStartMonth()
    {
        return $this->RangeStartMonth;
    }
    /**
     * Set RangeStartMonth value
     * @param string $rangeStartMonth
     * @return \StructType\MonthRange
     */
    public function setRangeStartMonth($rangeStartMonth = null)
    {
        // validation for constraint: string
        if (!is_null($rangeStartMonth) && !is_string($rangeStartMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rangeStartMonth)), __LINE__);
        }
        $this->RangeStartMonth = $rangeStartMonth;
        return $this;
    }
    /**
     * Get RangeEndMonth value
     * @return string|null
     */
    public function getRangeEndMonth()
    {
        return $this->RangeEndMonth;
    }
    /**
     * Set RangeEndMonth value
     * @param string $rangeEndMonth
     * @return \StructType\MonthRange
     */
    public function setRangeEndMonth($rangeEndMonth = null)
    {
        // validation for constraint: string
        if (!is_null($rangeEndMonth) && !is_string($rangeEndMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rangeEndMonth)), __LINE__);
        }
        $this->RangeEndMonth = $rangeEndMonth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonthRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
