<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOfferedCourses StructType
 * @subpackage Structs
 */
class GetOfferedCourses extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The EffectiveMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveMonth;
    /**
     * Constructor method for GetOfferedCourses
     * @uses GetOfferedCourses::setAPIKey()
     * @uses GetOfferedCourses::setEffectiveMonth()
     * @param string $aPIKey
     * @param string $effectiveMonth
     */
    public function __construct($aPIKey = null, $effectiveMonth = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setEffectiveMonth($effectiveMonth);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetOfferedCourses
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get EffectiveMonth value
     * @return string|null
     */
    public function getEffectiveMonth()
    {
        return $this->EffectiveMonth;
    }
    /**
     * Set EffectiveMonth value
     * @param string $effectiveMonth
     * @return \StructType\GetOfferedCourses
     */
    public function setEffectiveMonth($effectiveMonth = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMonth) && !is_string($effectiveMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveMonth)), __LINE__);
        }
        $this->EffectiveMonth = $effectiveMonth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOfferedCourses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
