<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOfferedCoursePrices StructType
 * @subpackage Structs
 */
class GetOfferedCoursePrices extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The CourseCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $CourseCodes;
    /**
     * The EffectiveMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveMonth;
    /**
     * Constructor method for GetOfferedCoursePrices
     * @uses GetOfferedCoursePrices::setAPIKey()
     * @uses GetOfferedCoursePrices::setCourseCodes()
     * @uses GetOfferedCoursePrices::setEffectiveMonth()
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfString $courseCodes
     * @param string $effectiveMonth
     */
    public function __construct($aPIKey = null, \ArrayType\ArrayOfString $courseCodes = null, $effectiveMonth = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setCourseCodes($courseCodes)
            ->setEffectiveMonth($effectiveMonth);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetOfferedCoursePrices
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get CourseCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCourseCodes()
    {
        return $this->CourseCodes;
    }
    /**
     * Set CourseCodes value
     * @param \ArrayType\ArrayOfString $courseCodes
     * @return \StructType\GetOfferedCoursePrices
     */
    public function setCourseCodes(\ArrayType\ArrayOfString $courseCodes = null)
    {
        $this->CourseCodes = $courseCodes;
        return $this;
    }
    /**
     * Get EffectiveMonth value
     * @return string|null
     */
    public function getEffectiveMonth()
    {
        return $this->EffectiveMonth;
    }
    /**
     * Set EffectiveMonth value
     * @param string $effectiveMonth
     * @return \StructType\GetOfferedCoursePrices
     */
    public function setEffectiveMonth($effectiveMonth = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMonth) && !is_string($effectiveMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveMonth)), __LINE__);
        }
        $this->EffectiveMonth = $effectiveMonth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOfferedCoursePrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
