<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCoursesBySectionNumber StructType
 * @subpackage Structs
 */
class GetCoursesBySectionNumber extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The SectionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SectionNumber;
    /**
     * Constructor method for GetCoursesBySectionNumber
     * @uses GetCoursesBySectionNumber::setAPIKey()
     * @uses GetCoursesBySectionNumber::setSectionNumber()
     * @param string $aPIKey
     * @param string $sectionNumber
     */
    public function __construct($aPIKey = null, $sectionNumber = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setSectionNumber($sectionNumber);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetCoursesBySectionNumber
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get SectionNumber value
     * @return string|null
     */
    public function getSectionNumber()
    {
        return $this->SectionNumber;
    }
    /**
     * Set SectionNumber value
     * @param string $sectionNumber
     * @return \StructType\GetCoursesBySectionNumber
     */
    public function setSectionNumber($sectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sectionNumber) && !is_string($sectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sectionNumber)), __LINE__);
        }
        $this->SectionNumber = $sectionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCoursesBySectionNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
