<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CourseStandardPrice StructType
 * @subpackage Structs
 */
class CourseStandardPrice extends AbstractStructBase
{
    /**
     * The WholesalePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $WholesalePrice;
    /**
     * The SuggestedRetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $SuggestedRetailPrice;
    /**
     * The CourseCode
     * @var string
     */
    public $CourseCode;
    /**
     * Constructor method for CourseStandardPrice
     * @uses CourseStandardPrice::setWholesalePrice()
     * @uses CourseStandardPrice::setSuggestedRetailPrice()
     * @uses CourseStandardPrice::setCourseCode()
     * @param \StructType\Price $wholesalePrice
     * @param \StructType\Price $suggestedRetailPrice
     * @param string $courseCode
     */
    public function __construct(\StructType\Price $wholesalePrice = null, \StructType\Price $suggestedRetailPrice = null, $courseCode = null)
    {
        $this
            ->setWholesalePrice($wholesalePrice)
            ->setSuggestedRetailPrice($suggestedRetailPrice)
            ->setCourseCode($courseCode);
    }
    /**
     * Get WholesalePrice value
     * @return \StructType\Price|null
     */
    public function getWholesalePrice()
    {
        return $this->WholesalePrice;
    }
    /**
     * Set WholesalePrice value
     * @param \StructType\Price $wholesalePrice
     * @return \StructType\CourseStandardPrice
     */
    public function setWholesalePrice(\StructType\Price $wholesalePrice = null)
    {
        $this->WholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get SuggestedRetailPrice value
     * @return \StructType\Price|null
     */
    public function getSuggestedRetailPrice()
    {
        return $this->SuggestedRetailPrice;
    }
    /**
     * Set SuggestedRetailPrice value
     * @param \StructType\Price $suggestedRetailPrice
     * @return \StructType\CourseStandardPrice
     */
    public function setSuggestedRetailPrice(\StructType\Price $suggestedRetailPrice = null)
    {
        $this->SuggestedRetailPrice = $suggestedRetailPrice;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\CourseStandardPrice
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CourseStandardPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
