<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoursePrice StructType
 * @subpackage Structs
 */
class CoursePrice extends AbstractStructBase
{
    /**
     * The RetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $RetailPrice;
    /**
     * The WholesalePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $WholesalePrice;
    /**
     * The SuggestedRetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $SuggestedRetailPrice;
    /**
     * The SectionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SectionNumber;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $StartDate;
    /**
     * The CourseCode
     * @var string
     */
    public $CourseCode;
    /**
     * Constructor method for CoursePrice
     * @uses CoursePrice::setRetailPrice()
     * @uses CoursePrice::setWholesalePrice()
     * @uses CoursePrice::setSuggestedRetailPrice()
     * @uses CoursePrice::setSectionNumber()
     * @uses CoursePrice::setStartDate()
     * @uses CoursePrice::setCourseCode()
     * @param \StructType\Price $retailPrice
     * @param \StructType\Price $wholesalePrice
     * @param \StructType\Price $suggestedRetailPrice
     * @param string $sectionNumber
     * @param \StructType\Date $startDate
     * @param string $courseCode
     */
    public function __construct(\StructType\Price $retailPrice = null, \StructType\Price $wholesalePrice = null, \StructType\Price $suggestedRetailPrice = null, $sectionNumber = null, \StructType\Date $startDate = null, $courseCode = null)
    {
        $this
            ->setRetailPrice($retailPrice)
            ->setWholesalePrice($wholesalePrice)
            ->setSuggestedRetailPrice($suggestedRetailPrice)
            ->setSectionNumber($sectionNumber)
            ->setStartDate($startDate)
            ->setCourseCode($courseCode);
    }
    /**
     * Get RetailPrice value
     * @return \StructType\Price|null
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param \StructType\Price $retailPrice
     * @return \StructType\CoursePrice
     */
    public function setRetailPrice(\StructType\Price $retailPrice = null)
    {
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get WholesalePrice value
     * @return \StructType\Price|null
     */
    public function getWholesalePrice()
    {
        return $this->WholesalePrice;
    }
    /**
     * Set WholesalePrice value
     * @param \StructType\Price $wholesalePrice
     * @return \StructType\CoursePrice
     */
    public function setWholesalePrice(\StructType\Price $wholesalePrice = null)
    {
        $this->WholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get SuggestedRetailPrice value
     * @return \StructType\Price|null
     */
    public function getSuggestedRetailPrice()
    {
        return $this->SuggestedRetailPrice;
    }
    /**
     * Set SuggestedRetailPrice value
     * @param \StructType\Price $suggestedRetailPrice
     * @return \StructType\CoursePrice
     */
    public function setSuggestedRetailPrice(\StructType\Price $suggestedRetailPrice = null)
    {
        $this->SuggestedRetailPrice = $suggestedRetailPrice;
        return $this;
    }
    /**
     * Get SectionNumber value
     * @return string|null
     */
    public function getSectionNumber()
    {
        return $this->SectionNumber;
    }
    /**
     * Set SectionNumber value
     * @param string $sectionNumber
     * @return \StructType\CoursePrice
     */
    public function setSectionNumber($sectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sectionNumber) && !is_string($sectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sectionNumber)), __LINE__);
        }
        $this->SectionNumber = $sectionNumber;
        return $this;
    }
    /**
     * Get StartDate value
     * @return \StructType\Date|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param \StructType\Date $startDate
     * @return \StructType\CoursePrice
     */
    public function setStartDate(\StructType\Date $startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\CoursePrice
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoursePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
