<?php

namespace CatalogMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set CatalogMgmt
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetCoursePrice
     * Meta informations extracted from the WSDL
     * - documentation: Sets courses price info.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=SetCoursePrice'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCoursePrice $parameters
     * @return \StructType\SetCoursePriceResponse|bool
     */
    public function SetCoursePrice(\StructType\SetCoursePrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCoursePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCourseSectionNumber
     * Meta informations extracted from the WSDL
     * - documentation: Sets course section number.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=SetCourseSectionNumber'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCourseSectionNumber $parameters
     * @return \StructType\SetCourseSectionNumberResponse|bool
     */
    public function SetCourseSectionNumber(\StructType\SetCourseSectionNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCourseSectionNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetCoursePriceResponse|\StructType\SetCourseSectionNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
