<?php

namespace CatalogMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove CatalogMgmt
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoveOfferedCourses
     * Meta informations extracted from the WSDL
     * - documentation: Removes courses offered by site for selected month range.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=RemoveOfferedCourses'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveOfferedCourses $parameters
     * @return \StructType\RemoveOfferedCoursesResponse|bool
     */
    public function RemoveOfferedCourses(\StructType\RemoveOfferedCourses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveOfferedCourses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveOfferedCoursesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
