<?php

namespace CatalogMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get CatalogMgmt
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCoursesBySectionNumber
     * Meta informations extracted from the WSDL
     * - documentation: Gets courses with given section number.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetCoursesBySectionNumber'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCoursesBySectionNumber $parameters
     * @return \StructType\GetCoursesBySectionNumberResponse|bool
     */
    public function GetCoursesBySectionNumber(\StructType\GetCoursesBySectionNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCoursesBySectionNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourseStandardPrices
     * Meta informations extracted from the WSDL
     * - documentation: Returns list of standard pricing info for provided course codes.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetCourseStandardPrices'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCourseStandardPrices $parameters
     * @return \StructType\GetCourseStandardPricesResponse|bool
     */
    public function GetCourseStandardPrices(\StructType\GetCourseStandardPrices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCourseStandardPrices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOfferedCoursePrices
     * Meta informations extracted from the WSDL
     * - documentation: Returns list of CoursePrice objects that contain pricing info for provided course codes.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetOfferedCoursePrices'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOfferedCoursePrices $parameters
     * @return \StructType\GetOfferedCoursePricesResponse|bool
     */
    public function GetOfferedCoursePrices(\StructType\GetOfferedCoursePrices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOfferedCoursePrices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOfferedCourses
     * Meta informations extracted from the WSDL
     * - documentation: Gets courses offered by site as of the provided effective date.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetOfferedCourses'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOfferedCourses $parameters
     * @return \StructType\GetOfferedCoursesResponse|bool
     */
    public function GetOfferedCourses(\StructType\GetOfferedCourses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOfferedCourses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSettings
     * Meta informations extracted from the WSDL
     * - documentation: Gets settings for site.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetSettings'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSettings $parameters
     * @return \StructType\GetSettingsResponse|bool
     */
    public function GetSettings(\StructType\GetSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnofferedCourses
     * Meta informations extracted from the WSDL
     * - documentation: Gets courses not offered by site as of the provided effective date.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CatalogManagerService&m=GetUnofferedCourses'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnofferedCourses $parameters
     * @return \StructType\GetUnofferedCoursesResponse|bool
     */
    public function GetUnofferedCourses(\StructType\GetUnofferedCourses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnofferedCourses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCoursesBySectionNumberResponse|\StructType\GetCourseStandardPricesResponse|\StructType\GetOfferedCoursePricesResponse|\StructType\GetOfferedCoursesResponse|\StructType\GetSettingsResponse|\StructType\GetUnofferedCoursesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
