<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CourseCode;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setCourseCode()
     * @param string[] $courseCode
     */
    public function __construct(array $courseCode = array())
    {
        $this
            ->setCourseCode($courseCode);
    }
    /**
     * Get CourseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCourseCode()
    {
        return isset($this->CourseCode) ? $this->CourseCode : null;
    }
    /**
     * Set CourseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $courseCode
     * @return \ArrayType\ArrayOfString
     */
    public function setCourseCode(array $courseCode = array())
    {
        foreach ($courseCode as $arrayOfStringCourseCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringCourseCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The CourseCode property can only contain items of string, "%s" given', is_object($arrayOfStringCourseCodeItem) ? get_class($arrayOfStringCourseCodeItem) : gettype($arrayOfStringCourseCodeItem)), __LINE__);
            }
        }
        if (is_null($courseCode) || (is_array($courseCode) && empty($courseCode))) {
            unset($this->CourseCode);
        } else {
            $this->CourseCode = $courseCode;
        }
        return $this;
    }
    /**
     * Add item to CourseCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString
     */
    public function addToCourseCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CourseCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CourseCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CourseCode
     */
    public function getAttributeName()
    {
        return 'CourseCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
