<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCoursePrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfCoursePrice extends AbstractStructArrayBase
{
    /**
     * The CoursePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CoursePrice[]
     */
    public $CoursePrice;
    /**
     * Constructor method for ArrayOfCoursePrice
     * @uses ArrayOfCoursePrice::setCoursePrice()
     * @param \StructType\CoursePrice[] $coursePrice
     */
    public function __construct(array $coursePrice = array())
    {
        $this
            ->setCoursePrice($coursePrice);
    }
    /**
     * Get CoursePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CoursePrice[]|null
     */
    public function getCoursePrice()
    {
        return isset($this->CoursePrice) ? $this->CoursePrice : null;
    }
    /**
     * Set CoursePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CoursePrice[] $coursePrice
     * @return \ArrayType\ArrayOfCoursePrice
     */
    public function setCoursePrice(array $coursePrice = array())
    {
        foreach ($coursePrice as $arrayOfCoursePriceCoursePriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfCoursePriceCoursePriceItem instanceof \StructType\CoursePrice) {
                throw new \InvalidArgumentException(sprintf('The CoursePrice property can only contain items of \StructType\CoursePrice, "%s" given', is_object($arrayOfCoursePriceCoursePriceItem) ? get_class($arrayOfCoursePriceCoursePriceItem) : gettype($arrayOfCoursePriceCoursePriceItem)), __LINE__);
            }
        }
        if (is_null($coursePrice) || (is_array($coursePrice) && empty($coursePrice))) {
            unset($this->CoursePrice);
        } else {
            $this->CoursePrice = $coursePrice;
        }
        return $this;
    }
    /**
     * Add item to CoursePrice value
     * @throws \InvalidArgumentException
     * @param \StructType\CoursePrice $item
     * @return \ArrayType\ArrayOfCoursePrice
     */
    public function addToCoursePrice(\StructType\CoursePrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoursePrice) {
            throw new \InvalidArgumentException(sprintf('The CoursePrice property can only contain items of \StructType\CoursePrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoursePrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CoursePrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CoursePrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CoursePrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CoursePrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CoursePrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CoursePrice
     */
    public function getAttributeName()
    {
        return 'CoursePrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCoursePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
