<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRegistrations StructType
 * @subpackage Structs
 */
class GetRegistrations extends AbstractStructBase
{
    /**
     * The RegistrationsFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\RegistrationsFilter
     */
    public $RegistrationsFilter;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The IncludeFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegistrationIncludeField4_1
     */
    public $IncludeFields;
    /**
     * Constructor method for GetRegistrations
     * @uses GetRegistrations::setRegistrationsFilter()
     * @uses GetRegistrations::setAPIKey()
     * @uses GetRegistrations::setIncludeFields()
     * @param \StructType\RegistrationsFilter $registrationsFilter
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfRegistrationIncludeField4_1 $includeFields
     */
    public function __construct(\StructType\RegistrationsFilter $registrationsFilter = null, $aPIKey = null, \ArrayType\ArrayOfRegistrationIncludeField4_1 $includeFields = null)
    {
        $this
            ->setRegistrationsFilter($registrationsFilter)
            ->setAPIKey($aPIKey)
            ->setIncludeFields($includeFields);
    }
    /**
     * Get RegistrationsFilter value
     * @return \StructType\RegistrationsFilter
     */
    public function getRegistrationsFilter()
    {
        return $this->RegistrationsFilter;
    }
    /**
     * Set RegistrationsFilter value
     * @param \StructType\RegistrationsFilter $registrationsFilter
     * @return \StructType\GetRegistrations
     */
    public function setRegistrationsFilter(\StructType\RegistrationsFilter $registrationsFilter = null)
    {
        $this->RegistrationsFilter = $registrationsFilter;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetRegistrations
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get IncludeFields value
     * @return \ArrayType\ArrayOfRegistrationIncludeField4_1|null
     */
    public function getIncludeFields()
    {
        return $this->IncludeFields;
    }
    /**
     * Set IncludeFields value
     * @param \ArrayType\ArrayOfRegistrationIncludeField4_1 $includeFields
     * @return \StructType\GetRegistrations
     */
    public function setIncludeFields(\ArrayType\ArrayOfRegistrationIncludeField4_1 $includeFields = null)
    {
        $this->IncludeFields = $includeFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRegistrations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
