<?php

namespace RegistrationSrvc;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update RegistrationSrvc
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateRegistration
     * Meta informations extracted from the WSDL
     * - documentation: Updates the registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=UpdateRegistration'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRegistration $parameters
     * @return \StructType\UpdateRegistrationResponse|bool
     */
    public function UpdateRegistration(\StructType\UpdateRegistration $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateRegistration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateRegistrationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
