<?php

namespace EnumType;

/**
 * This class stands for TagOperator EnumType
 * @subpackage Enumerations
 */
class TagOperator
{
    /**
     * Constant for value 'AND'
     * @return string 'AND'
     */
    const VALUE_AND = 'AND';
    /**
     * Constant for value 'OR'
     * @return string 'OR'
     */
    const VALUE_OR = 'OR';
    /**
     * Constant for value 'NOT'
     * @return string 'NOT'
     */
    const VALUE_NOT = 'NOT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AND
     * @uses self::VALUE_OR
     * @uses self::VALUE_NOT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AND,
            self::VALUE_OR,
            self::VALUE_NOT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
