<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString3 extends AbstractStructArrayBase
{
    /**
     * The SectionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SectionNumber;
    /**
     * Constructor method for ArrayOfString3
     * @uses ArrayOfString3::setSectionNumber()
     * @param string[] $sectionNumber
     */
    public function __construct(array $sectionNumber = array())
    {
        $this
            ->setSectionNumber($sectionNumber);
    }
    /**
     * Get SectionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSectionNumber()
    {
        return isset($this->SectionNumber) ? $this->SectionNumber : null;
    }
    /**
     * Set SectionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $sectionNumber
     * @return \ArrayType\ArrayOfString3
     */
    public function setSectionNumber(array $sectionNumber = array())
    {
        foreach ($sectionNumber as $arrayOfString3SectionNumberItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString3SectionNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The SectionNumber property can only contain items of string, "%s" given', is_object($arrayOfString3SectionNumberItem) ? get_class($arrayOfString3SectionNumberItem) : gettype($arrayOfString3SectionNumberItem)), __LINE__);
            }
        }
        if (is_null($sectionNumber) || (is_array($sectionNumber) && empty($sectionNumber))) {
            unset($this->SectionNumber);
        } else {
            $this->SectionNumber = $sectionNumber;
        }
        return $this;
    }
    /**
     * Add item to SectionNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString3
     */
    public function addToSectionNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SectionNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SectionNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SectionNumber
     */
    public function getAttributeName()
    {
        return 'SectionNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
