<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivity ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivity extends AbstractStructArrayBase
{
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Activity[]
     */
    public $Activity;
    /**
     * Constructor method for ArrayOfActivity
     * @uses ArrayOfActivity::setActivity()
     * @param \StructType\Activity[] $activity
     */
    public function __construct(array $activity = array())
    {
        $this
            ->setActivity($activity);
    }
    /**
     * Get Activity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Activity[]|null
     */
    public function getActivity()
    {
        return isset($this->Activity) ? $this->Activity : null;
    }
    /**
     * Set Activity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Activity[] $activity
     * @return \ArrayType\ArrayOfActivity
     */
    public function setActivity(array $activity = array())
    {
        foreach ($activity as $arrayOfActivityActivityItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityActivityItem instanceof \StructType\Activity) {
                throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of \StructType\Activity, "%s" given', is_object($arrayOfActivityActivityItem) ? get_class($arrayOfActivityActivityItem) : gettype($arrayOfActivityActivityItem)), __LINE__);
            }
        }
        if (is_null($activity) || (is_array($activity) && empty($activity))) {
            unset($this->Activity);
        } else {
            $this->Activity = $activity;
        }
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\Activity $item
     * @return \ArrayType\ArrayOfActivity
     */
    public function addToActivity(\StructType\Activity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Activity) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of \StructType\Activity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Activity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Activity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Activity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Activity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Activity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Activity
     */
    public function getAttributeName()
    {
        return 'Activity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
