<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Progress StructType
 * @subpackage Structs
 */
class Progress extends AbstractStructBase
{
    /**
     * The PercentProgress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PercentProgress;
    /**
     * The CoursePassed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CoursePassed;
    /**
     * The PercentOverallScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PercentOverallScore;
    /**
     * The RegistrationKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUID
     */
    public $RegistrationKey;
    /**
     * The LastAccessDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $LastAccessDate;
    /**
     * The CompletionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $CompletionDate;
    /**
     * The TotalTimeSpent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Timespan
     */
    public $TotalTimeSpent;
    /**
     * The Custom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Custom
     */
    public $Custom;
    /**
     * Constructor method for Progress
     * @uses Progress::setPercentProgress()
     * @uses Progress::setCoursePassed()
     * @uses Progress::setPercentOverallScore()
     * @uses Progress::setRegistrationKey()
     * @uses Progress::setLastAccessDate()
     * @uses Progress::setCompletionDate()
     * @uses Progress::setTotalTimeSpent()
     * @uses Progress::setCustom()
     * @param float $percentProgress
     * @param bool $coursePassed
     * @param float $percentOverallScore
     * @param \StructType\GUID $registrationKey
     * @param \StructType\Date $lastAccessDate
     * @param \StructType\Date $completionDate
     * @param \StructType\Timespan $totalTimeSpent
     * @param \StructType\Custom $custom
     */
    public function __construct($percentProgress = null, $coursePassed = null, $percentOverallScore = null, \StructType\GUID $registrationKey = null, \StructType\Date $lastAccessDate = null, \StructType\Date $completionDate = null, \StructType\Timespan $totalTimeSpent = null, \StructType\Custom $custom = null)
    {
        $this
            ->setPercentProgress($percentProgress)
            ->setCoursePassed($coursePassed)
            ->setPercentOverallScore($percentOverallScore)
            ->setRegistrationKey($registrationKey)
            ->setLastAccessDate($lastAccessDate)
            ->setCompletionDate($completionDate)
            ->setTotalTimeSpent($totalTimeSpent)
            ->setCustom($custom);
    }
    /**
     * Get PercentProgress value
     * @return float
     */
    public function getPercentProgress()
    {
        return $this->PercentProgress;
    }
    /**
     * Set PercentProgress value
     * @param float $percentProgress
     * @return \StructType\Progress
     */
    public function setPercentProgress($percentProgress = null)
    {
        $this->PercentProgress = $percentProgress;
        return $this;
    }
    /**
     * Get CoursePassed value
     * @return bool
     */
    public function getCoursePassed()
    {
        return $this->CoursePassed;
    }
    /**
     * Set CoursePassed value
     * @param bool $coursePassed
     * @return \StructType\Progress
     */
    public function setCoursePassed($coursePassed = null)
    {
        // validation for constraint: boolean
        if (!is_null($coursePassed) && !is_bool($coursePassed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($coursePassed)), __LINE__);
        }
        $this->CoursePassed = $coursePassed;
        return $this;
    }
    /**
     * Get PercentOverallScore value
     * @return float
     */
    public function getPercentOverallScore()
    {
        return $this->PercentOverallScore;
    }
    /**
     * Set PercentOverallScore value
     * @param float $percentOverallScore
     * @return \StructType\Progress
     */
    public function setPercentOverallScore($percentOverallScore = null)
    {
        $this->PercentOverallScore = $percentOverallScore;
        return $this;
    }
    /**
     * Get RegistrationKey value
     * @return \StructType\GUID|null
     */
    public function getRegistrationKey()
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param \StructType\GUID $registrationKey
     * @return \StructType\Progress
     */
    public function setRegistrationKey(\StructType\GUID $registrationKey = null)
    {
        $this->RegistrationKey = $registrationKey;
        return $this;
    }
    /**
     * Get LastAccessDate value
     * @return \StructType\Date|null
     */
    public function getLastAccessDate()
    {
        return $this->LastAccessDate;
    }
    /**
     * Set LastAccessDate value
     * @param \StructType\Date $lastAccessDate
     * @return \StructType\Progress
     */
    public function setLastAccessDate(\StructType\Date $lastAccessDate = null)
    {
        $this->LastAccessDate = $lastAccessDate;
        return $this;
    }
    /**
     * Get CompletionDate value
     * @return \StructType\Date|null
     */
    public function getCompletionDate()
    {
        return $this->CompletionDate;
    }
    /**
     * Set CompletionDate value
     * @param \StructType\Date $completionDate
     * @return \StructType\Progress
     */
    public function setCompletionDate(\StructType\Date $completionDate = null)
    {
        $this->CompletionDate = $completionDate;
        return $this;
    }
    /**
     * Get TotalTimeSpent value
     * @return \StructType\Timespan|null
     */
    public function getTotalTimeSpent()
    {
        return $this->TotalTimeSpent;
    }
    /**
     * Set TotalTimeSpent value
     * @param \StructType\Timespan $totalTimeSpent
     * @return \StructType\Progress
     */
    public function setTotalTimeSpent(\StructType\Timespan $totalTimeSpent = null)
    {
        $this->TotalTimeSpent = $totalTimeSpent;
        return $this;
    }
    /**
     * Get Custom value
     * @return \StructType\Custom|null
     */
    public function getCustom()
    {
        return $this->Custom;
    }
    /**
     * Set Custom value
     * @param \StructType\Custom $custom
     * @return \StructType\Progress
     */
    public function setCustom(\StructType\Custom $custom = null)
    {
        $this->Custom = $custom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Progress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
