<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom StructType
 * @subpackage Structs
 */
class Custom extends AbstractStructBase
{
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Field[]
     */
    public $Field;
    /**
     * Constructor method for Custom
     * @uses Custom::setField()
     * @param \StructType\Field[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get Field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Field[]|null
     */
    public function getField()
    {
        return isset($this->Field) ? $this->Field : null;
    }
    /**
     * Set Field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Field[] $field
     * @return \StructType\Custom
     */
    public function setField(array $field = array())
    {
        foreach ($field as $customFieldItem) {
            // validation for constraint: itemType
            if (!$customFieldItem instanceof \StructType\Field) {
                throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \StructType\Field, "%s" given', is_object($customFieldItem) ? get_class($customFieldItem) : gettype($customFieldItem)), __LINE__);
            }
        }
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->Field);
        } else {
            $this->Field = $field;
        }
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param \StructType\Field $item
     * @return \StructType\Custom
     */
    public function addToField(\StructType\Field $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Field) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of \StructType\Field, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Custom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
