<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddRegistration StructType
 * @subpackage Structs
 */
class AddRegistration extends AbstractStructBase
{
    /**
     * The RetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RetailPrice;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The StudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StudentKey;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseCode;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Tags;
    /**
     * Constructor method for AddRegistration
     * @uses AddRegistration::setRetailPrice()
     * @uses AddRegistration::setAPIKey()
     * @uses AddRegistration::setStudentKey()
     * @uses AddRegistration::setCourseCode()
     * @uses AddRegistration::setStartDate()
     * @uses AddRegistration::setTags()
     * @param float $retailPrice
     * @param string $aPIKey
     * @param string $studentKey
     * @param string $courseCode
     * @param string $startDate
     * @param \ArrayType\ArrayOfString $tags
     */
    public function __construct($retailPrice = null, $aPIKey = null, $studentKey = null, $courseCode = null, $startDate = null, \ArrayType\ArrayOfString $tags = null)
    {
        $this
            ->setRetailPrice($retailPrice)
            ->setAPIKey($aPIKey)
            ->setStudentKey($studentKey)
            ->setCourseCode($courseCode)
            ->setStartDate($startDate)
            ->setTags($tags);
    }
    /**
     * Get RetailPrice value
     * @return float
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param float $retailPrice
     * @return \StructType\AddRegistration
     */
    public function setRetailPrice($retailPrice = null)
    {
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\AddRegistration
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get StudentKey value
     * @return string|null
     */
    public function getStudentKey()
    {
        return $this->StudentKey;
    }
    /**
     * Set StudentKey value
     * @param string $studentKey
     * @return \StructType\AddRegistration
     */
    public function setStudentKey($studentKey = null)
    {
        // validation for constraint: string
        if (!is_null($studentKey) && !is_string($studentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentKey)), __LINE__);
        }
        $this->StudentKey = $studentKey;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\AddRegistration
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\AddRegistration
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfString $tags
     * @return \StructType\AddRegistration
     */
    public function setTags(\ArrayType\ArrayOfString $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
